/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.Arrays;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Security;

public class Objects {
    public static boolean equals(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return object1 == object2;
        }
        if (object1.getClass().isArray() && object2.getClass().isArray()) {
            if (object1 instanceof boolean[] && object2 instanceof boolean[]) {
                return Arrays.equals((boolean[])object1, (boolean[])object2);
            }
            if (object1 instanceof byte[] && object2 instanceof byte[]) {
                return Arrays.equals((byte[])object1, (byte[])object2);
            }
            if (object1 instanceof char[] && object2 instanceof char[]) {
                return Arrays.equals((char[])object1, (char[])object2);
            }
            if (object1 instanceof double[] && object2 instanceof double[]) {
                return Arrays.equals((double[])object1, (double[])object2);
            }
            if (object1 instanceof float[] && object2 instanceof float[]) {
                return Arrays.equals((float[])object1, (float[])object2);
            }
            if (object1 instanceof int[] && object2 instanceof int[]) {
                return Arrays.equals((int[])object1, (int[])object2);
            }
            if (object1 instanceof long[] && object2 instanceof long[]) {
                return Arrays.equals((long[])object1, (long[])object2);
            }
            if (object1 instanceof short[] && object2 instanceof short[]) {
                return Arrays.equals((short[])object1, (short[])object2);
            }
            return Arrays.equals((Object[])object1, (Object[])object2);
        }
        return object1.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        byte[] byArray;
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(bytes);
        try {
            output.writeObject(object);
            output.flush();
            byArray = bytes.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                Resources.close(output);
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Resources.close(output);
        return byArray;
    }

    public static <T> T deserialize(byte[] bytes) {
        return Objects.deserialize(bytes, Objects.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(byte[] bytes, ClassLoader loader) {
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
            try {
                T t = Objects.readObject(input, loader);
                return t;
            }
            finally {
                Resources.close(input);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T readObject(ObjectInput input) {
        return Objects.readObject(input, Objects.class.getClassLoader());
    }

    public static <T> T readObject(ObjectInput input, ClassLoader loader) {
        ClassLoader originalLoader = Objects.getThreadContextClassLoader();
        Objects.setThreadContextClassLoader(loader);
        try {
            Object object = input.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Objects.setThreadContextClassLoader(originalLoader);
        }
    }

    private Objects() {
    }

    private static ClassLoader getThreadContextClassLoader() {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return Security.run(action);
    }

    private static void setThreadContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        };
        Security.run(action);
    }
}

