/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.util.Matcher;

public class ServiceLoaders {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaders.class);

    public static <T> T findService(Class<T> serviceClass) {
        Iterator<T> i$ = ServiceLoader.load(serviceClass, serviceClass.getClassLoader()).iterator();
        if (i$.hasNext()) {
            T service = i$.next();
            return service;
        }
        return null;
    }

    public static <T> T findRequiredService(Class<T> serviceClass) {
        T service = ServiceLoaders.findService(serviceClass);
        if (service == null) {
            throw new IllegalStateException(String.format("No %s found", serviceClass.getName()));
        }
        return service;
    }

    public static <T> T findService(Matcher<T> matcher, Class<T> serviceClass) {
        LinkedList<T> matches = new LinkedList<T>();
        for (T service : ServiceLoader.load(serviceClass, serviceClass.getClassLoader())) {
            if (!matcher.matches(service)) continue;
            matches.add(service);
        }
        if (matches.size() > 1) {
            logger.log(Level.WARN, "Multiple {0} found matching {1}: {2}", serviceClass.getName(), matcher, matches);
        }
        return !matches.isEmpty() ? (T)matches.get(0) : null;
    }

    public static <T> T findRequiredService(Matcher<T> matcher, Class<T> serviceClass) {
        T service = ServiceLoaders.findService(matcher, serviceClass);
        if (service == null) {
            throw new IllegalArgumentException(String.format("No %s found matching %s", serviceClass.getName(), matcher));
        }
        return service;
    }

    private ServiceLoaders() {
    }
}

