/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.sf.hajdbc.util.SystemProperties;

public final class Strings {
    public static final String ANY = "%";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOT = ".";
    public static final String EMPTY = "";
    public static final String PADDED_COMMA = ", ";
    public static final String QUESTION = "?";
    public static final String UNDERSCORE = "_";
    public static final String TAB = "\t";
    public static final String NEW_LINE = SystemProperties.getSystemProperty("line.separator");
    public static final String FILE_SEPARATOR = SystemProperties.getSystemProperty("file.separator");
    public static final String PATH_SEPARATOR = SystemProperties.getSystemProperty("path.separator");
    public static final String USER_HOME = SystemProperties.getSystemProperty("user.home");
    public static final String HA_JDBC_HOME = USER_HOME + FILE_SEPARATOR + ".ha-jdbc";

    public static StringBuilder join(StringBuilder builder, Collection<String> collection, String delimiter) {
        Iterator<String> elements = collection.iterator();
        while (elements.hasNext()) {
            builder.append(elements.next());
            if (!elements.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder;
    }

    public static String join(Collection<String> collection, String delimiter) {
        return Strings.join(new StringBuilder(), collection, delimiter).toString();
    }

    public static String join(String[] strings, String delimiter) {
        return Strings.join(Arrays.asList(strings), delimiter);
    }

    public static StringBuilder join(StringBuilder builder, String[] strings, String delimiter) {
        return Strings.join(builder, Arrays.asList(strings), delimiter);
    }

    private Strings() {
    }
}

