/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util;

import java.security.PrivilegedAction;
import java.util.Properties;
import net.sf.hajdbc.util.Security;

public class SystemProperties {
    public static String getSystemProperty(String name) {
        return SystemProperties.getSystemProperty(name, null);
    }

    public static String getSystemProperty(final String name, final String defaultValue) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return Security.run(action);
    }

    public static Properties getSystemProperties() {
        PrivilegedAction<Properties> action = new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
        return Security.run(action);
    }

    public static void setSystemProperty(final String name, final String value) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(name, value);
                return null;
            }
        };
        Security.run(action);
    }

    private SystemProperties() {
    }
}

