/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.Lifecycle;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.util.concurrent.Registry;
import net.sf.hajdbc.util.concurrent.RegistryStoreFactory;

public class LifecycleRegistry<K, V extends Lifecycle, C, E extends Exception>
implements Registry<K, V, C, E> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Registry.Store<K, RegistryEntry> store;
    final Registry.Factory<K, V, C, E> factory;
    final ExceptionFactory<E> exceptionFactory;

    public LifecycleRegistry(Registry.Factory<K, V, C, E> factory, RegistryStoreFactory<K> storeFactory, ExceptionFactory<E> exceptionFactory) {
        this.store = storeFactory.createStore();
        this.factory = factory;
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    public V get(K key, C context) throws E {
        RegistryEntry entry = this.store.get(key);
        if (entry != null) {
            return entry.getValue();
        }
        Lifecycle value = (Lifecycle)this.factory.create(key, context);
        entry = new RegistryEntry(this, value);
        RegistryEntry existing = this.store.setIfAbsent(key, entry);
        if (existing != null) {
            return existing.getValue();
        }
        try {
            value.start();
            entry.started();
            return (V)value;
        }
        catch (Exception e) {
            this.store.clear(key);
            try {
                value.stop();
            }
            catch (Exception re) {
                this.logger.log(Level.INFO, re);
            }
            throw this.exceptionFactory.createException(e);
        }
    }

    @Override
    public void remove(K key) throws E {
        RegistryEntry entry = this.store.clear(key);
        if (entry != null) {
            entry.getValue().stop();
        }
    }

    private static class RegistryEntry {
        private final V value;
        private final AtomicReference<CountDownLatch> latchRef = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        final /* synthetic */ LifecycleRegistry this$0;

        RegistryEntry(V value) {
            this.this$0 = var1_1;
            this.value = value;
        }

        V getValue() throws Exception {
            CountDownLatch latch = this.latchRef.get();
            if (latch != null) {
                try {
                    if (!latch.await(this.this$0.factory.getTimeout(), this.this$0.factory.getTimeoutUnit())) {
                        throw this.this$0.exceptionFactory.createException(new TimeoutException());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.this$0.exceptionFactory.createException(e);
                }
            }
            return this.value;
        }

        void started() {
            CountDownLatch latch = this.latchRef.getAndSet(null);
            if (latch != null) {
                latch.countDown();
            }
        }
    }
}

