/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.hajdbc.util.concurrent.Registry;
import net.sf.hajdbc.util.concurrent.RegistryStoreFactory;

public class MapRegistryStoreFactory<K>
implements RegistryStoreFactory<K> {
    @Override
    public <V> Registry.Store<K, V> createStore() {
        return new MapRegistryStore();
    }

    static class MapRegistryStore<K, V>
    implements Registry.Store<K, V> {
        private final ConcurrentMap<K, V> map = new ConcurrentHashMap();

        MapRegistryStore() {
        }

        @Override
        public V setIfAbsent(K key, V value) {
            return this.map.putIfAbsent(key, value);
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public V clear(K key) {
            return this.map.remove(key);
        }
    }
}

