/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import net.sf.hajdbc.util.concurrent.Registry;
import net.sf.hajdbc.util.concurrent.RegistryStoreFactory;

public class ReferenceRegistryStoreFactory
implements RegistryStoreFactory<Void> {
    @Override
    public <V> Registry.Store<Void, V> createStore() {
        return new ReferenceRegistryStore();
    }

    static class ReferenceRegistryStore<V>
    implements Registry.Store<Void, V> {
        private final AtomicReference<V> reference = new AtomicReference();

        ReferenceRegistryStore() {
        }

        @Override
        public V setIfAbsent(Void key, V value) {
            return this.reference.compareAndSet(null, value) ? null : (V)this.reference.get();
        }

        @Override
        public V get(Void key) {
            return this.reference.get();
        }

        @Override
        public V clear(Void key) {
            return this.reference.getAndSet(null);
        }
    }
}

