/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SynchronousExecutor
extends AbstractExecutorService {
    private final ExecutorService executor;
    private final boolean reverse;

    public SynchronousExecutor(ExecutorService executor) {
        this(executor, false);
    }

    public SynchronousExecutor(ExecutorService executor, boolean reverse) {
        this.executor = executor;
        this.reverse = reverse;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(time, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public void execute(Runnable task) {
        task.run();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(Executors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return new SynchronousFuture<T>(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Callable<T>> taskList = new ArrayList<Callable<T>>(tasks);
        if (this.reverse) {
            Collections.reverse(taskList);
        }
        boolean synchronous = !this.reverse;
        int remaining = tasks.size();
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(remaining);
        for (Callable<T> callable : tasks) {
            if (synchronous || this.reverse && --remaining == 0) {
                Future<T> future = new SynchronousFuture<T>(callable);
                futureList.add(future);
                if (!((SynchronousFuture)future).isSuccessful() || remaining <= 2) continue;
                synchronous = false;
                continue;
            }
            futureList.add(this.executor.submit(callable));
        }
        if (this.reverse) {
            Collections.reverse(futureList);
        }
        try {
            for (Future future : futureList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                }
                catch (CancellationException e) {}
            }
            ArrayList<Future<T>> arrayList = futureList;
            return arrayList;
        }
        finally {
            for (Future<T> future : futureList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Callable<T>> taskList = new ArrayList<Callable<T>>(tasks);
        if (this.reverse) {
            Collections.reverse(taskList);
        }
        boolean synchronous = !this.reverse;
        int remaining = tasks.size();
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(remaining);
        for (Callable<T> task : tasks) {
            if (synchronous || this.reverse && --remaining == 0) {
                Future<T> future = new SynchronousFuture<T>(task);
                futureList.add(future);
                if (!((SynchronousFuture)future).isSuccessful() || remaining <= 1) continue;
                synchronous = false;
                continue;
            }
            futureList.add(this.executor.submit(task));
        }
        if (this.reverse) {
            Collections.reverse(futureList);
        }
        boolean interrupted = true;
        try {
            for (Future<T> future : futureList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                }
                catch (CancellationException cancellationException) {}
            }
            interrupted = false;
            ArrayList<Future<T>> arrayList = futureList;
            return arrayList;
        }
        finally {
            if (interrupted) {
                for (Future future : futureList) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getAny(this.invokeAll(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getAny(this.invokeAll(tasks, timeout, unit));
    }

    private <T> T getAny(List<Future<T>> futures) throws InterruptedException, ExecutionException {
        if (futures.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return futures.get(this.reverse ? futures.size() - 1 : 0).get();
    }

    static class SynchronousFuture<T>
    implements Future<T> {
        private T result;
        private ExecutionException exception;

        SynchronousFuture(Callable<T> task) {
            try {
                this.result = task.call();
            }
            catch (Throwable e) {
                this.exception = new ExecutionException(e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public T get() throws ExecutionException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        @Override
        public T get(long time, TimeUnit unit) throws ExecutionException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        boolean isSuccessful() {
            return this.exception == null;
        }
    }
}

