/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.concurrent.cron;

import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.sf.hajdbc.util.concurrent.cron.CronExecutorService;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;

public class CronThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements CronExecutorService {
    public CronThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public CronThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public CronThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public CronThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    public void schedule(final Runnable task, final CronExpression expression) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.setCorePoolSize(this.getCorePoolSize() + 1);
        Runnable scheduleTask = new Runnable(){

            @Override
            public void run() {
                Date now = new Date();
                Date time = expression.getNextValidTimeAfter(now);
                try {
                    while (time != null) {
                        CronThreadPoolExecutor.this.schedule(task, time.getTime() - now.getTime(), TimeUnit.MILLISECONDS);
                        while (now.before(time)) {
                            Thread.sleep(time.getTime() - now.getTime());
                            now = new Date();
                        }
                        time = expression.getNextValidTimeAfter(now);
                    }
                }
                catch (RejectedExecutionException e) {
                }
                catch (CancellationException e) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.execute(scheduleTask);
    }
}

