/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.hajdbc.ExceptionFactory;

public final class Methods {
    public static <R, E extends Exception> R invoke(Method method, ExceptionFactory<E> factory, Object object, Object ... parameters) throws E {
        try {
            return (R)method.invoke(object, parameters);
        }
        catch (InvocationTargetException e) {
            throw factory.createException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw factory.createException(e);
        }
    }

    public static Set<Method> findMethods(Class<?> sourceClass, String ... patterns) {
        LinkedList<Method> list = new LinkedList<Method>();
        Method[] methods = sourceClass.getMethods();
        for (String regex : patterns) {
            Pattern pattern = Pattern.compile(regex);
            for (Method method : methods) {
                if (!pattern.matcher(method.getName()).matches()) continue;
                list.add(method);
            }
        }
        return new HashSet<Method>(list);
    }

    public static Method getMethod(Class<?> sourceClass, String name, Class<?> ... types) {
        try {
            return sourceClass.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method findMethod(Class<?> sourceClass, String name, Class<?> ... types) {
        try {
            return sourceClass.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findMethod(String className, String name, Class<?> ... types) {
        try {
            return Methods.findMethod(Methods.class.getClassLoader().loadClass(className), name, types);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Methods() {
    }
}

