/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.xml;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.hajdbc.util.Strings;
import net.sf.hajdbc.util.SystemProperties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class PropertyReplacementFilter
extends XMLFilterImpl {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private final Properties properties;

    public PropertyReplacementFilter() {
        this.properties = SystemProperties.getSystemProperties();
    }

    public PropertyReplacementFilter(XMLReader parent) {
        this(parent, SystemProperties.getSystemProperties());
    }

    public PropertyReplacementFilter(XMLReader parent, Properties properties) {
        super(parent);
        this.properties = properties;
    }

    @Override
    public void characters(char[] data, int start, int length) throws SAXException {
        char[] value = this.replace(String.copyValueOf(data, start, length)).toCharArray();
        super.characters(value, 0, value.length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        AttributesImpl attributes = attrs instanceof AttributesImpl ? (AttributesImpl)attrs : new AttributesImpl(attrs);
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            attributes.setValue(i, this.replace(attributes.getValue(i)));
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private String replace(String input) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = PATTERN.matcher(input);
        int tail = 0;
        while (matcher.find()) {
            builder.append(input, tail, matcher.start());
            String group = matcher.group(1);
            if (group.equals("/")) {
                builder.append(Strings.FILE_SEPARATOR);
            } else if (group.equals(":")) {
                builder.append(Strings.PATH_SEPARATOR);
            } else {
                String value;
                String key = group;
                String defaultValue = null;
                int index = group.indexOf(":");
                if (index > 0) {
                    key = group.substring(0, index);
                    defaultValue = group.substring(index + 1);
                }
                builder.append((value = this.getProperty(key.split(","), defaultValue)) != null ? value : matcher.group());
            }
            tail = matcher.end();
        }
        builder.append(input, tail, input.length());
        return builder.toString();
    }

    private String getProperty(String[] keys, String defaultValue) {
        for (String key : keys) {
            String value = this.properties.getProperty(key.trim());
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }
}

