/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class SchemaGenerator {
    public static final String NAMESPACE = "urn:ha-jdbc:cluster:2.1";

    public static void main(String ... args) throws Throwable {
        try {
            assert (args.length == 3) : String.format("Usage: java %s <base-class-name> <base-directory> <filename>", SchemaGenerator.class.getName());
            String baseClassName = args[0];
            String baseDirectoryName = args[1];
            String fileName = args[2];
            Class<?> baseClass = SchemaGenerator.class.getClassLoader().loadClass(baseClassName);
            File baseDirectory = new File(baseDirectoryName);
            final File file = new File(baseDirectory, fileName);
            SchemaOutputResolver resolver = new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    return new StreamResult(file);
                }
            };
            System.out.println(String.format("Generating schema to %s", file.getPath()));
            JAXBContext.newInstance((Class[])new Class[]{baseClass}).generateSchema(resolver);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }
}

