/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.Version;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.util.SystemProperties;
import net.sf.hajdbc.xml.FileXMLStreamFactory;
import net.sf.hajdbc.xml.PropertyReplacementFilter;
import net.sf.hajdbc.xml.URLXMLStreamFactory;
import net.sf.hajdbc.xml.XMLStreamFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLDatabaseClusterConfigurationFactory<Z, D extends Database<Z>>
implements DatabaseClusterConfigurationFactory<Z, D> {
    private static final long serialVersionUID = -8796872297122349961L;
    private static final String CONFIG_PROPERTY_FORMAT = "ha-jdbc.{0}.configuration";
    private static final String CONFIG_PROPERTY = "ha-jdbc.configuration";
    private static final String DEFAULT_RESOURCE = "ha-jdbc-{0}.xml";
    private static final URL SCHEMA = XMLDatabaseClusterConfigurationFactory.findResource("ha-jdbc.xsd", new ClassLoader[0]);
    private static final Logger logger = LoggerFactory.getLogger(XMLDatabaseClusterConfigurationFactory.class);
    private final Class<? extends DatabaseClusterConfiguration<Z, D>> targetClass;
    private final XMLStreamFactory streamFactory;

    private static String identifyResource(String id) {
        String resource = SystemProperties.getSystemProperty(MessageFormat.format(CONFIG_PROPERTY_FORMAT, id));
        return resource != null ? resource : MessageFormat.format(SystemProperties.getSystemProperty(CONFIG_PROPERTY, DEFAULT_RESOURCE), id);
    }

    private static URL findResource(String resource, ClassLoader loader) {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            return XMLDatabaseClusterConfigurationFactory.findResource(resource, loader, XMLDatabaseClusterConfigurationFactory.class.getClassLoader(), ClassLoader.getSystemClassLoader());
        }
    }

    private static URL findResource(String resource, ClassLoader ... loaders) {
        if (loaders.length == 0) {
            return XMLDatabaseClusterConfigurationFactory.findResource(resource, Thread.currentThread().getContextClassLoader());
        }
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(Messages.CONFIG_NOT_FOUND.getMessage(resource));
    }

    public XMLDatabaseClusterConfigurationFactory(Class<? extends DatabaseClusterConfiguration<Z, D>> targetClass, String id, String resource) {
        this(targetClass, id, resource, Thread.currentThread().getContextClassLoader());
    }

    public XMLDatabaseClusterConfigurationFactory(Class<? extends DatabaseClusterConfiguration<Z, D>> targetClass, String id, String resource, ClassLoader loader) {
        this(targetClass, XMLDatabaseClusterConfigurationFactory.findResource(resource == null ? XMLDatabaseClusterConfigurationFactory.identifyResource(id) : MessageFormat.format(resource, id), loader));
    }

    public XMLDatabaseClusterConfigurationFactory(Class<? extends DatabaseClusterConfiguration<Z, D>> targetClass, URL url) {
        this(targetClass, url.getProtocol().equals("file") ? new FileXMLStreamFactory(url) : new URLXMLStreamFactory(url));
    }

    public XMLDatabaseClusterConfigurationFactory(Class<? extends DatabaseClusterConfiguration<Z, D>> targetClass, XMLStreamFactory streamFactory) {
        this.targetClass = targetClass;
        this.streamFactory = streamFactory;
    }

    @Override
    public DatabaseClusterConfiguration<Z, D> createConfiguration() throws SQLException {
        logger.log(Level.INFO, Messages.HA_JDBC_INIT.getMessage(new Object[0]), Version.getVersion(), this.streamFactory);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(SCHEMA);
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{this.targetClass}).createUnmarshaller();
            unmarshaller.setSchema(schema);
            PropertyReplacementFilter reader = new PropertyReplacementFilter(XMLReaderFactory.createXMLReader());
            InputSource source = SAXSource.sourceToInputSource(this.streamFactory.createSource());
            return this.targetClass.cast(unmarshaller.unmarshal((Source)new SAXSource(reader, source)));
        }
        catch (JAXBException e) {
            throw new SQLException(e);
        }
        catch (SAXException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void added(D database, DatabaseClusterConfiguration<Z, D> configuration) {
        this.export(configuration);
    }

    @Override
    public void removed(D database, DatabaseClusterConfiguration<Z, D> configuration) {
        this.export(configuration);
    }

    public void export(DatabaseClusterConfiguration<Z, D> configuration) {
        JAXB.marshal(configuration, (Result)this.streamFactory.createResult());
    }
}

