/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.admin.AdministrativeFlowDescriptor;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeAdministrativeProfileContextTree
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAdministrativeProfileContextTree.class);
    @Nullable
    private AdministrativeFlowDescriptor flowDescriptor;
    @Nullable
    private List<String> fallbackLanguages;

    public void setAdministrativeFlowDescriptor(@Nullable AdministrativeFlowDescriptor descriptor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.flowDescriptor = descriptor;
    }

    public void setFallbackLanguages(@Nonnull @NonnullElements List<String> langs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.fallbackLanguages = langs != null ? new ArrayList<String>(Collections2.filter(langs, (Predicate)Predicates.notNull())) : null;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.flowDescriptor == null) {
            this.log.warn("{} Administrative profile '{}' not enabled", (Object)this.getLogPrefix(), (Object)profileRequestContext.getProfileId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!this.flowDescriptor.getId().equals(profileRequestContext.getProfileId())) {
            this.log.warn("{} Profile ID '{}' doesn't match descriptor ID '{}", new Object[]{this.getLogPrefix(), profileRequestContext.getProfileId(), this.flowDescriptor.getId()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.setLoggingId(this.flowDescriptor.getLoggingId());
        profileRequestContext.setBrowserProfile(!this.flowDescriptor.isNonBrowserSupported());
        RelyingPartyContext rpCtx = new RelyingPartyContext();
        profileRequestContext.addSubcontext((BaseContext)rpCtx, true);
        rpCtx.setRelyingPartyId(this.flowDescriptor.getId());
        rpCtx.setProfileConfig((ProfileConfiguration)this.flowDescriptor);
        RelyingPartyUIContext uiCtx = (RelyingPartyUIContext)rpCtx.getSubcontext(RelyingPartyUIContext.class, true);
        uiCtx.setRPUInfo(this.flowDescriptor.getUIInfo());
        uiCtx.setBrowserLanguages(this.getBrowserLanguages());
        if (null != this.fallbackLanguages) {
            uiCtx.setFallbackLanguages(this.fallbackLanguages);
        }
    }

    @Nonnull
    @NonnullElements
    private List<String> getBrowserLanguages() {
        Enumeration locales = this.getHttpServletRequest().getLocales();
        LazyList languages = new LazyList();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (null == locale.getLanguage()) continue;
            languages.add(locale.getLanguage());
        }
        return languages;
    }
}

