/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.security.BasicKeystoreKeyStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockDataSealers
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String KEYSTORE_PASSWORD_PARAM_NAME = "keystorePassword";
    @Nonnull
    @NotEmpty
    public static final String KEY_PASSWORD_PARAM_NAME = "keyPassword";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(UnlockDataSealers.class);
    @Nonnull
    @NonnullElements
    private Collection<BasicKeystoreKeyStrategy> keyStrategies = Collections.emptyList();

    public void setKeyStrategies(@Nullable @NonnullElements Collection<BasicKeystoreKeyStrategy> strategies) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyStrategies = strategies != null && !strategies.isEmpty() ? new ArrayList<BasicKeystoreKeyStrategy>(Collections2.filter(strategies, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.keyStrategies.isEmpty()) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        String[] keystorePasswords = request.getParameterValues(KEYSTORE_PASSWORD_PARAM_NAME);
        String[] keyPasswords = request.getParameterValues(KEY_PASSWORD_PARAM_NAME);
        if (keystorePasswords == null || keyPasswords == null || keystorePasswords.length != this.keyStrategies.size() || keyPasswords.length != this.keyStrategies.size()) {
            this.log.warn("{} Password parameter count does not match size of configured KeyStrategy inputs", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        int i = 0;
        for (BasicKeystoreKeyStrategy ks : this.keyStrategies) {
            if (keystorePasswords[i] == null || keyPasswords[i] == null) {
                this.log.warn("{} Empty password supplied at index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ks.setKeystorePassword(keystorePasswords[i]);
            ks.setKeyPassword(keyPasswords[i]);
            try {
                ks.getDefaultKey();
            }
            catch (KeyException e) {
                this.log.warn("{} Failed to unlock key strategy in collection with index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ++i;
        }
    }
}

