/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.cryptacular.EncodingException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.MutableCredential;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class UnlockPrivateKeys
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String KEY_PASSWORD_PARAM_NAME = "privateKeyPassword";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(UnlockPrivateKeys.class);
    @Nonnull
    @NonnullElements
    private Collection<MutableCredential> credentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private Collection<Resource> keyResources = Collections.emptyList();

    public void setCredentials(@Nullable @NonnullElements Collection<MutableCredential> creds) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.credentials = creds != null && !creds.isEmpty() ? new ArrayList<MutableCredential>(Collections2.filter(creds, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    public void setKeyResources(@Nullable @NonnullElements Collection<Resource> keys) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyResources = keys != null && !keys.isEmpty() ? new ArrayList<Resource>(Collections2.filter(keys, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.keyResources.size() != this.credentials.size()) {
            throw new ComponentInitializationException("Size of credential and key resource collections don't match.");
        }
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.credentials.isEmpty() || this.keyResources.isEmpty()) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        String[] keyPasswords = this.getHttpServletRequest().getParameterValues(KEY_PASSWORD_PARAM_NAME);
        if (keyPasswords == null || keyPasswords.length != this.credentials.size()) {
            this.log.warn("{} Password parameter count does not match number of configured credentials", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        int i = 0;
        Iterator<MutableCredential> c_iter = this.credentials.iterator();
        Iterator<Resource> k_iter = this.keyResources.iterator();
        while (c_iter.hasNext() && k_iter.hasNext()) {
            MutableCredential cred = c_iter.next();
            Resource resource = k_iter.next();
            if (keyPasswords[i] == null) {
                this.log.warn("{} Empty password supplied at index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.info("{} Attempting unlock of private key in {}", (Object)this.getLogPrefix(), (Object)resource.getDescription());
            try (InputStream is = resource.getInputStream();){
                cred.setPrivateKey(KeySupport.decodePrivateKey((InputStream)is, (char[])keyPasswords[i].toCharArray()));
                this.log.info("{} Unlocked and injected private key in {}", (Object)this.getLogPrefix(), (Object)resource.getDescription());
            }
            catch (IOException | KeyException | EncodingException e) {
                this.log.warn("{} Failed to unlock private key with index {}", new Object[]{this.getLogPrefix(), i, e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ++i;
        }
    }
}

