/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.admin.impl.JarCheckArguments;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarCheckCLI
extends AbstractIdPHomeAwareCommandLine<JarCheckArguments> {
    @Nullable
    private Logger log;
    @Nonnull
    private List<String> webAppJars = Collections.emptyList();
    @Nonnull
    private List<String> pluginJars = Collections.emptyList();
    @Nonnull
    private List<String> distJars = Collections.emptyList();

    private void loadJarFiles(JarCheckArguments args) {
        Path idpHome = Path.of(args.getIdPHome(), new String[0]);
        this.distJars = this.listJars(idpHome.resolve("dist").resolve("webapp"));
        this.pluginJars = this.listJars(idpHome.resolve("dist").resolve("plugin-webapp"));
        this.webAppJars = this.listJars(idpHome.resolve("edit-webapp"));
    }

    private List<String> listJars(Path webapp) {
        Path libDir = webapp.resolve("WEB-INF").resolve("lib");
        if (!Files.exists(libDir, new LinkOption[0]) || !Files.isDirectory(libDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Arrays.asList(libDir.toFile().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameUpper = name.toUpperCase();
                return nameUpper.endsWith(".JAR");
            }
        }));
    }

    private void listAndExactCheck(JarCheckArguments args) {
        HashMap<String, String> allNames = new HashMap<String, String>(this.distJars.size() + this.pluginJars.size() + this.webAppJars.size());
        String type = "jar called";
        this.addAndCheck(allNames, this.distJars, "distribution", "jar called");
        this.addAndCheck(allNames, this.pluginJars, "plugins", "jar called");
        this.addAndCheck(allNames, this.webAppJars, "edit-webapp", "jar called");
        if (!args.isList()) {
            return;
        }
        ArrayList names = new ArrayList(allNames.keySet());
        Collections.sort(names);
        System.out.println("Sorted List of jars");
        System.out.println(String.format("  %-22s %s", "Name", "Source"));
        for (String jarName : names) {
            System.out.println(String.format("  %-22s %s", jarName, allNames.get(jarName)));
        }
    }

    private void addAndCheck(Map<String, String> allNames, List<String> jars, String source, String type) {
        for (String jar : jars) {
            String current = allNames.get(jar);
            if (current == null) {
                allNames.put(jar, source);
                continue;
            }
            this.getLogger().warn("{} {} found in {} and in {}", new Object[]{type, jar, source, current});
        }
    }

    protected Class<JarCheckArguments> getArgumentClass() {
        return JarCheckArguments.class;
    }

    protected String getVersion() {
        return Version.getVersion();
    }

    protected synchronized Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(JarCheckCLI.class);
        }
        return this.log;
    }

    private void fileNamesOnly(JarCheckArguments args) {
        HashMap<String, String> allNames = new HashMap<String, String>(this.distJars.size() + this.pluginJars.size() + this.webAppJars.size());
        String type = "jar fragment called";
        this.addAndCheck(allNames, this.normalize(this.distJars), "distribution", "jar fragment called");
        this.addAndCheck(allNames, this.normalize(this.pluginJars), "plugins", "jar fragment called");
        this.addAndCheck(allNames, this.normalize(this.webAppJars), "edit-webapp", "jar fragment called");
    }

    private List<String> normalize(List<String> fileNames) {
        Pattern patt = Pattern.compile("^(.*)-[0123456789](.*)\\.jar$");
        ArrayList<String> result = new ArrayList<String>(fileNames.size());
        for (String name : fileNames) {
            Matcher matcher = patt.matcher(name);
            if (!matcher.find()) continue;
            result.add(matcher.group(1));
        }
        return result;
    }

    private void detailed(JarCheckArguments args) {
        HashMap<String, String> allNames = new HashMap<String, String>();
        Path idpHome = Path.of(args.getIdPHome(), new String[0]);
        this.processClassNames(allNames, idpHome.resolve("dist").resolve("webapp"), this.distJars);
        this.processClassNames(allNames, idpHome.resolve("dist").resolve("plugin-webapp"), this.pluginJars);
        this.processClassNames(allNames, idpHome.resolve("edit-webapp"), this.webAppJars);
    }

    private void processClassNames(Map<String, String> namesSoFar, Path base, List<String> jars) {
        Path libdir = base.resolve("WEB-INF").resolve("lib");
        for (String jar : jars) {
            this.processClassNames(namesSoFar, libdir.resolve(jar));
        }
    }

    private void processClassNames(Map<String, String> namesSoFar, Path jar) {
        String source = jar.toString();
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(jar.toFile()));
             ZipArchiveInputStream classes = new ZipArchiveInputStream((InputStream)inStream);){
            ArchiveEntry entry = null;
            while ((entry = classes.getNextEntry()) != null) {
                String claz;
                if (entry.isDirectory() || (claz = entry.getName()) == null || claz.startsWith("META-INF") || "module-info.class".equals(claz)) continue;
                String current = namesSoFar.get(claz);
                if (current == null) {
                    namesSoFar.put(claz, source);
                    continue;
                }
                this.getLogger().warn("class {} found in {} and in {}", new Object[]{claz, source, current});
            }
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("Could not open {}", (Object)source, (Object)e);
        }
        catch (IOException e) {
            this.getLogger().error("Could not process {}", (Object)source, (Object)e);
        }
    }

    protected int doRun(@Nonnull JarCheckArguments args) {
        int ret = super.doRun((AbstractIdPHomeAwareCommandLineArguments)args);
        if (ret != 0) {
            return ret;
        }
        this.loadJarFiles(args);
        this.listAndExactCheck(args);
        if (args.isDetailed()) {
            this.detailed(args);
        } else {
            this.fileNamesOnly(args);
        }
        return 0;
    }

    public static void main(@Nonnull String[] args) {
        System.exit(new JarCheckCLI().run(args));
    }
}

