/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.admin.impl.DoStorageOperation;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.joda.time.Instant;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DoStorageOperationTest {
    @Nonnull
    @NotEmpty
    private static final String CONTEXT = "testContext";
    @Nonnull
    @NotEmpty
    private static final String KEY = "testKey";
    @Nonnull
    @NotEmpty
    private static final String VALUE = "testValue";
    private MemoryStorageService storageService;
    private ObjectMapper mapper;
    private DoStorageOperation action;
    private RequestContext rc;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().buildRequestContext();
        this.request = (MockHttpServletRequest)this.rc.getExternalContext().getNativeRequest();
        this.response = (MockHttpServletResponse)this.rc.getExternalContext().getNativeResponse();
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.setCleanupInterval(Duration.ZERO);
        this.storageService.initialize();
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.action = new DoStorageOperation();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return DoStorageOperationTest.this.request;
            }
        });
        this.action.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return DoStorageOperationTest.this.response;
            }
        });
        this.action.setStorageService((StorageService)this.storageService);
        this.action.setObjectMapper(this.mapper);
        this.action.initialize();
    }

    @AfterMethod
    public void tearDown() {
        this.action.destroy();
        this.storageService.destroy();
    }

    @Test
    public void noParams() {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
    }

    @Test
    public void invalidMethod() {
        this.request.setMethod("FOO");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)405);
    }

    @Test
    public void missingGet() {
        this.request.setMethod("GET");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
    }

    @Test
    public void successGet() throws IOException, ParseException {
        long exp = Instant.now().getMillis() + Duration.ofMinutes(15L).toMillis();
        this.storageService.create(CONTEXT, KEY, VALUE, Long.valueOf(exp));
        this.request.setMethod("GET");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Map record = (Map)this.mapper.readerFor(Map.class).readValue(this.response.getContentAsByteArray());
        Map data = (Map)record.get("data");
        Assert.assertEquals(data.get("type"), (Object)"records");
        Assert.assertEquals(data.get("id"), (Object)"test/testContext/testKey");
        Map attributes = (Map)data.get("attributes");
        Assert.assertEquals(attributes.get("value"), (Object)VALUE);
        Assert.assertEquals(attributes.get("version"), (Object)1);
        Assert.assertEquals(attributes.get("expiration"), (Object)exp);
    }

    @Test
    public void missingDelete() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("DELETE");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)"testKey2");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
        Assert.assertNotNull((Object)this.storageService.read(CONTEXT, KEY));
    }

    @Test
    public void successDelete() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("DELETE");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)204);
        Assert.assertNull((Object)this.storageService.read(CONTEXT, KEY));
    }

    @Test
    public void successCreate() throws IOException, ParseException {
        this.request.setMethod("PUT");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"testValue\" }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)201);
        StorageRecord record = this.storageService.read(CONTEXT, KEY);
        Assert.assertEquals((long)record.getVersion(), (long)1L);
        Assert.assertEquals((String)record.getValue(), (String)VALUE);
    }

    @Test
    public void duplicateCreate() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("PUT");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"testValue\" }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)409);
    }

    @Test
    public void successUpdate() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("POST");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"changed\" }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        StorageRecord record = this.storageService.read(CONTEXT, KEY);
        Assert.assertEquals((long)record.getVersion(), (long)2L);
        Assert.assertEquals((String)record.getValue(), (String)"changed");
    }

    @Test
    public void successUpdateAsCreate() throws IOException, ParseException {
        this.request.setMethod("POST");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"testValue\" }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)201);
        StorageRecord record = this.storageService.read(CONTEXT, KEY);
        Assert.assertEquals((long)record.getVersion(), (long)1L);
        Assert.assertEquals((String)record.getValue(), (String)VALUE);
    }

    @Test
    public void successUpdateWithVersion() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("POST");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"changed\", \"version\": 1 }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        StorageRecord record = this.storageService.read(CONTEXT, KEY);
        Assert.assertEquals((long)record.getVersion(), (long)2L);
        Assert.assertEquals((String)record.getValue(), (String)"changed");
    }

    @Test
    public void failedUpdateWithVersion() throws IOException, ParseException {
        this.storageService.create(CONTEXT, KEY, VALUE, null);
        this.request.setMethod("POST");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"changed\", \"version\": 2 }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)409);
        StorageRecord record = this.storageService.read(CONTEXT, KEY);
        Assert.assertEquals((long)record.getVersion(), (long)1L);
        Assert.assertEquals((String)record.getValue(), (String)VALUE);
    }

    @Test
    public void missingUpdateWithVersion() throws IOException, ParseException {
        this.request.setMethod("POST");
        this.rc.getFlowScope().put("context", (Object)CONTEXT);
        this.rc.getFlowScope().put("key", (Object)KEY);
        this.request.setContent("{ \"value\": \"changed\", \"version\": 2 }".getBytes());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
        Assert.assertNull((Object)this.storageService.read(CONTEXT, KEY));
    }
}

