/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.admin.AdministrativeFlowDescriptor;
import net.shibboleth.idp.admin.BasicAdministrativeFlowDescriptor;
import net.shibboleth.idp.admin.impl.InitializeAdministrativeProfileContextTree;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.LangBearingString;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeAdministrativeProfileContextTreeTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private InitializeAdministrativeProfileContextTree action;
    private BasicAdministrativeFlowDescriptor descriptor;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.descriptor = new BasicAdministrativeFlowDescriptor("foo");
        this.descriptor.setLoggingId("log");
        this.descriptor.setNonBrowserSupported(true);
        this.descriptor.setDisplayNames(Collections.singletonList(new LangBearingString("name", "en")));
        this.descriptor.setDescriptions(Collections.singletonList(new LangBearingString("description", "en")));
        this.descriptor.setLogos(Collections.singletonList(new BasicAdministrativeFlowDescriptor.Logo("http://logo", null, 10, 10)));
        this.action = new InitializeAdministrativeProfileContextTree();
        this.action.setAdministrativeFlowDescriptor((AdministrativeFlowDescriptor)this.descriptor);
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return (HttpServletRequest)InitializeAdministrativeProfileContextTreeTest.this.src.getExternalContext().getNativeRequest();
            }
        });
        this.action.initialize();
    }

    @Test
    public void testNoDescriptor() throws ComponentInitializationException {
        this.action = new InitializeAdministrativeProfileContextTree();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testBadDescriptor() throws ComponentInitializationException {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testAction() throws Exception {
        this.prc.setProfileId("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.prc.getLoggingId(), (String)"log");
        RelyingPartyContext rpc = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        Assert.assertNotNull((Object)rpc);
        Assert.assertEquals((String)rpc.getRelyingPartyId(), (String)"foo");
        Assert.assertNotNull((Object)rpc.getProfileConfig());
        Assert.assertSame((Object)rpc.getProfileConfig(), (Object)this.descriptor);
        RelyingPartyUIContext ui = (RelyingPartyUIContext)rpc.getSubcontext(RelyingPartyUIContext.class);
        Assert.assertNotNull((Object)ui);
        Assert.assertEquals((String)ui.getServiceName(), (String)"name");
        Assert.assertEquals((String)ui.getServiceDescription(), (String)"description");
        Assert.assertEquals((String)ui.getLogo(), (String)"http://logo");
    }
}

