/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.cryptacular.EncodingException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.MutableCredential;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public class UnlockPrivateKeys
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String KEY_PASSWORD_PARAM_NAME = "privateKeyPassword";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(UnlockPrivateKeys.class);
    @Nonnull
    private Collection<MutableCredential> credentials = CollectionSupport.emptyList();
    @Nonnull
    private Collection<Resource> keyResources = CollectionSupport.emptyList();

    public void setCredentials(@Nullable Collection<MutableCredential> creds) {
        this.checkSetterPreconditions();
        this.credentials = creds != null ? CollectionSupport.copyToList(creds) : CollectionSupport.emptyList();
    }

    public void setKeyResources(@Nullable Collection<Resource> keys) {
        this.checkSetterPreconditions();
        this.keyResources = keys != null ? CollectionSupport.copyToList(keys) : CollectionSupport.emptyList();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.keyResources.size() != this.credentials.size()) {
            throw new ComponentInitializationException("Size of credential and key resource collections don't match.");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.credentials.isEmpty() || this.keyResources.isEmpty()) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        String[] keyPasswords = request.getParameterValues(KEY_PASSWORD_PARAM_NAME);
        if (keyPasswords == null || keyPasswords.length != this.credentials.size()) {
            this.log.warn("{} Password parameter count does not match number of configured credentials", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        int i = 0;
        Iterator<MutableCredential> cIter = this.credentials.iterator();
        Iterator<Resource> kIter = this.keyResources.iterator();
        while (cIter.hasNext() && kIter.hasNext()) {
            MutableCredential cred = cIter.next();
            Resource resource = kIter.next();
            if (keyPasswords[i] == null) {
                this.log.warn("{} Empty password supplied at index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.info("{} Attempting unlock of private key in {}", (Object)this.getLogPrefix(), (Object)resource.getDescription());
            try (InputStream is = resource.getInputStream();){
                cred.setPrivateKey(KeySupport.decodePrivateKey((InputStream)is, (char[])keyPasswords[i].toCharArray()));
                this.log.info("{} Unlocked and injected private key in {}", (Object)this.getLogPrefix(), (Object)resource.getDescription());
            }
            catch (IOException | KeyException | EncodingException e) {
                this.log.warn("{} Failed to unlock private key with index {}", new Object[]{this.getLogPrefix(), i, e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ++i;
        }
    }
}

