/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputDataConnectorParser;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseResolverPluginParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    private String defnId = "<Unnamed Attribute or Connector>";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseResolverPluginParser.class);

    @Nonnull
    @NotEmpty
    protected String getDefinitionId() {
        return this.defnId;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String id = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        this.log.info("Parsing configuration for {} plugin with id: {}", (Object)config.getLocalName(), (Object)id);
        builder.addPropertyValue("id", (Object)id);
        if (null != id) {
            this.defnId = id;
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            if (config.hasAttributeNS(null, "relyingParties")) {
                this.log.warn("relyingParties ignored, using activationConditionRef");
            }
            builder.addPropertyReference("activationCondition", StringSupport.trimOrNull((String)config.getAttributeNS(null, "activationConditionRef")));
        } else if (config.hasAttributeNS(null, "relyingParties")) {
            BeanDefinitionBuilder rpBuilder = BeanDefinitionBuilder.genericBeanDefinition(RelyingPartyIdPredicate.class);
            rpBuilder.setFactoryMethod("fromCandidates");
            rpBuilder.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)config.getAttributeNodeNS(null, "relyingParties")));
            builder.addPropertyValue("activationCondition", (Object)rpBuilder.getBeanDefinition());
        }
        if (config.hasAttributeNS(null, "profileContextStrategyRef")) {
            builder.addPropertyReference("profileContextStrategy", StringSupport.trimOrNull((String)config.getAttributeNS(null, "profileContextStrategyRef")));
        }
        if (config.hasAttributeNS(null, "propagateResolutionExceptions")) {
            builder.addPropertyValue("propagateResolutionExceptions", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "propagateResolutionExceptions")));
        }
        List attributeDependencyElements = ElementSupport.getChildElements((Node)config, (QName)InputAttributeDefinitionParser.ELEMENT_NAME);
        List dataConnectorDependencyElements = ElementSupport.getChildElements((Node)config, (QName)InputDataConnectorParser.ELEMENT_NAME);
        if (null != attributeDependencyElements && !attributeDependencyElements.isEmpty() || null != dataConnectorDependencyElements && !dataConnectorDependencyElements.isEmpty()) {
            if (this.failOnDependencies()) {
                this.log.error("{} Dependencies are not allowed.", (Object)this.getLogPrefix());
                throw new BeanCreationException(this.getLogPrefix() + " has meaningless Dependencies statements");
            }
            if (this.warnOnDependencies()) {
                this.log.warn("{} Dependencies are not allowed.", (Object)this.getLogPrefix());
            }
        }
        builder.addPropertyValue("attributeDependencies", (Object)SpringSupport.parseCustomElements((Collection)attributeDependencyElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        builder.addPropertyValue("dataConnectorDependencies", (Object)SpringSupport.parseCustomElements((Collection)dataConnectorDependencyElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
    }

    protected boolean failOnDependencies() {
        return false;
    }

    protected boolean warnOnDependencies() {
        return false;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Unknown Plugin '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

