/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.impl.AbstractResolverPluginFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class DataConnectorFactoryBean
extends AbstractResolverPluginFactoryBean<AbstractDataConnector>
implements ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DataConnectorFactoryBean.class);
    @Nonnull
    private Class<? extends AbstractDataConnector> connectorClass;
    @Nullable
    private List<Resource> resources;
    @Nullable
    private ApplicationContext parentContext;
    private GenericApplicationContext appContext;
    @Nonnull
    @NonnullElements
    private List<BeanFactoryPostProcessor> factoryPostProcessors = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<BeanPostProcessor> postProcessors = Collections.emptyList();
    @Nullable
    private String failoverDataConnectorId;
    @Nullable
    private Duration noRetryDelay;
    private Boolean exportAllAttributes;
    @Nonnull
    @NonnullElements
    private Collection<String> exportAttributes = Collections.emptySet();

    @Nullable
    public String getFailoverDataConnectorId() {
        return this.failoverDataConnectorId;
    }

    public void setFailoverDataConnectorId(@Nullable String id) {
        this.failoverDataConnectorId = id;
    }

    @Nullable
    public Duration getNoRetryDelay() {
        return this.noRetryDelay;
    }

    public void setNoRetryDelay(@Nullable Duration delay) {
        this.noRetryDelay = delay;
    }

    public void setResources(@Nonnull @NonnullElements List<Resource> theResources) {
        this.resources = List.copyOf((Collection)Constraint.isNotNull(theResources, (String)"Resources cannot be null"));
    }

    @Nonnull
    @NonnullElements
    public List<Resource> getResources() {
        return this.resources;
    }

    public void setExportAttributes(@Nonnull Collection<String> what) {
        this.exportAttributes = what.stream().map(StringSupport::trimOrNull).collect(Collectors.toSet());
    }

    public void setExportAllAttributes(boolean what) {
        this.exportAllAttributes = what;
    }

    public void setBeanFactoryPostProcessors(@Nonnull @NonnullElements List<BeanFactoryPostProcessor> processors) {
        this.factoryPostProcessors = List.copyOf((Collection)Constraint.isNotNull(processors, (String)"BeanFactoryPostProcessors cannot be null"));
    }

    @Nonnull
    @NonnullElements
    public List<BeanFactoryPostProcessor> getBeanFactoryPostProcessors() {
        return this.factoryPostProcessors;
    }

    public void setBeanPostProcessors(@Nonnull @NonnullElements List<BeanPostProcessor> processors) {
        this.postProcessors = List.copyOf((Collection)Constraint.isNotNull(processors, (String)"BeanPostProcessors cannot be null"));
    }

    @Nonnull
    @NonnullElements
    public List<BeanPostProcessor> getBeanPostProcessors() {
        return this.postProcessors;
    }

    @Override
    protected void setValues(AbstractDataConnector what) {
        super.setValues(what);
        if (null != this.getFailoverDataConnectorId()) {
            what.setFailoverDataConnectorId(this.getFailoverDataConnectorId());
        }
        if (null != this.exportAllAttributes) {
            what.setExportAllAttributes(this.exportAllAttributes.booleanValue());
        } else if (!this.exportAttributes.isEmpty()) {
            what.setExportAttributes(this.exportAttributes);
        }
    }

    public void setSingleton(boolean singleton) {
        Constraint.isTrue((boolean)singleton, (String)"Can only be singleton");
        super.setSingleton(singleton);
    }

    public void setObjectType(@Nonnull Class<? extends AbstractDataConnector> claz) {
        this.connectorClass = (Class)Constraint.isNotNull(claz, (String)"Injected class must be non-null");
    }

    public Class<? extends AbstractDataConnector> getObjectType() {
        return this.connectorClass;
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    protected void destroyInstance(AbstractDataConnector instance) throws Exception {
        super.destroyInstance((Object)instance);
        this.appContext.close();
    }

    protected AbstractDataConnector doCreateInstance() throws Exception {
        PropertyDescriptor[] descriptors;
        Constraint.isNotNull(this.getObjectType(), (String)"Injected class must be non-null");
        this.log.debug("Creating a DataConnector of type {} from resources {}", this.getObjectType(), this.resources);
        Constructor<? extends AbstractDataConnector> constructor = this.getObjectType().getConstructor(new Class[0]);
        AbstractDataConnector result = constructor.newInstance(new Object[0]);
        if (null != this.getFailoverDataConnectorId()) {
            result.setFailoverDataConnectorId(this.getFailoverDataConnectorId());
        }
        if (null != this.getNoRetryDelay()) {
            result.setNoRetryDelay(this.getNoRetryDelay());
        }
        this.setValues(result);
        this.appContext = new ApplicationContextBuilder().setName("HybridSpringDataConnector").setServiceConfigurations(this.getResources()).setBeanFactoryPostProcessors(this.getBeanFactoryPostProcessors()).setBeanPostProcessors(this.getBeanPostProcessors()).setParentContext(this.getParentContext()).build();
        for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(this.getObjectType(), AbstractDataConnector.class).getPropertyDescriptors()) {
            this.log.debug("Parsing property descriptor: {}", (Object)descriptor);
            Map beans = this.appContext.getBeansOfType(descriptor.getPropertyType());
            if (null == beans || beans.isEmpty() || null == descriptor.getWriteMethod()) continue;
            if (beans.size() > 1) {
                this.log.warn("Too many beans of type {} found, only the first will be used", descriptor.getPropertyType());
            }
            Object bean = beans.values().iterator().next();
            this.log.debug("Added property value: {}", bean);
            descriptor.getWriteMethod().invoke((Object)result, bean);
        }
        return result;
    }
}

