/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedConnectionParser {
    @Nonnull
    public static final QName CONTAINER_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ContainerManagedConnection");
    @Nonnull
    public static final QName BEAN_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "BeanManagedConnection");
    @Nonnull
    public static final QName SIMPLE_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SimpleManagedConnection");
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ManagedConnectionParser.class);
    @Nonnull
    private final Element configElement;

    public ManagedConnectionParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nullable
    public BeanDefinition createDataSource() {
        List containerManagedElements = ElementSupport.getChildElements((Node)this.configElement, (QName)CONTAINER_MANAGED_CONNECTION_RESOLVER);
        List simpleManagedElements = ElementSupport.getChildElements((Node)this.configElement, (QName)SIMPLE_MANAGED_CONNECTION_RESOLVER);
        if (simpleManagedElements.size() + containerManagedElements.size() > 1) {
            LOG.warn("Only one <SimpleManagedConnection> or <ContainerManagedConnection> is allowed per DataConnector");
        }
        if (!simpleManagedElements.isEmpty()) {
            return this.createSimpleManagedDataSource((Element)simpleManagedElements.get(0));
        }
        if (!containerManagedElements.isEmpty()) {
            return this.createContainerManagedDataSource((Element)containerManagedElements.get(0));
        }
        return null;
    }

    @Nonnull
    protected BeanDefinition createContainerManagedDataSource(@Nonnull Element containerManagedElement) {
        Constraint.isNotNull((Object)containerManagedElement, (String)"ContainerManagedConnection element cannot be null");
        String resourceName = AttributeSupport.getAttributeValue((Element)containerManagedElement, (QName)new QName("resourceName"));
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.rootBeanDefinition(ManagedConnectionParser.class, (String)"buildDataSource");
        dataSource.addConstructorArgValue((Object)resourceName);
        return dataSource.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition createSimpleManagedDataSource(@Nonnull Element simpleManagedElement) {
        String password;
        Constraint.isNotNull((Object)simpleManagedElement, (String)"SimpleManagedConnection element cannot be null");
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.genericBeanDefinition(BasicDataSource.class);
        String driverName = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcDriver"));
        if (driverName == null) {
            LOG.warn("<SimpleManagedConnection> jdbcDriver attribute should be present and non empty");
            throw new BeanCreationException("<SimpleManagedConnection> jdbcDriver attribute should be present and non empty");
        }
        dataSource.addPropertyValue("driverClassName", (Object)driverName);
        String url = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcURL"));
        if (url == null) {
            LOG.warn("<SimpleManagedConnection> jdbcURL attribute should be present and non empty");
            throw new BeanCreationException("<SimpleManagedConnection> jdbcURL attribute should be present and non empty");
        }
        dataSource.addPropertyValue("url", (Object)url);
        String user = AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcUserName");
        if (user != null && !"".equals(user)) {
            dataSource.addPropertyValue("username", (Object)user);
        }
        if ((password = AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcPassword")) != null && !"".equals(password)) {
            dataSource.addPropertyValue("password", (Object)password);
        }
        dataSource.addPropertyValue("maxTotal", (Object)"20");
        dataSource.addPropertyValue("maxIdle", (Object)"5");
        dataSource.addPropertyValue("maxWaitMillis", (Object)"5000");
        return dataSource.getBeanDefinition();
    }

    @Nullable
    public static DataSource buildDataSource(String resourceName) {
        try {
            InitialContext initCtx = new InitialContext();
            DataSource dataSource = (DataSource)initCtx.lookup(resourceName);
            return dataSource;
        }
        catch (NamingException e) {
            LOG.error("Managed data source '{}' could not be found", (Object)resourceName, (Object)e);
            return null;
        }
    }

    @Nullable
    public static String getBeanDataSourceID(@Nonnull Element config) {
        List beanManagedElements = ElementSupport.getChildElements((Node)config, (QName)BEAN_MANAGED_CONNECTION_RESOLVER);
        if (beanManagedElements.isEmpty()) {
            return null;
        }
        if (beanManagedElements.size() > 1) {
            LOG.warn("Only one <BeanManagedConnection> should be specified; the first one has been consulted");
        }
        List managedElements = ElementSupport.getChildElements((Node)config, (QName)CONTAINER_MANAGED_CONNECTION_RESOLVER);
        managedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)SIMPLE_MANAGED_CONNECTION_RESOLVER));
        if (managedElements.size() > 0) {
            LOG.warn("<BeanManagedConnection> is incompatible with <ContainerManagedConnection>or <SimpleManagedConnection>. The <BeanManagedConnection> has been used");
        }
        return StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)((Element)beanManagedElements.get(0))));
    }
}

