/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.impl.PairwiseIdDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PairwiseIdDataConnectorParser
extends BaseResolverPluginParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "PairwiseId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PairwiseIdDataConnectorParser.class);

    protected Class<PairwiseIdDataConnector> getBeanClass(Element element) {
        return PairwiseIdDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        this.doParse(config, parserContext, builder, "pairwiseId");
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder, @Nullable String generatedIdDefaultName) {
        List failoverConnector;
        super.doParse(config, parserContext, builder);
        String generatedAttribute = config.hasAttributeNS(null, "generatedAttributeID") ? StringSupport.trimOrNull((String)config.getAttributeNS(null, "generatedAttributeID")) : generatedIdDefaultName;
        builder.addPropertyValue("generatedAttributeId", (Object)generatedAttribute);
        if (((Object)((Object)this)).getClass().equals(PairwiseIdDataConnectorParser.class)) {
            builder.addPropertyReference("pairwiseIdStore", config.getAttributeNS(null, "pairwiseIdStoreRef"));
        }
        if ((failoverConnector = ElementSupport.getChildElements((Node)config, (QName)AbstractDataConnectorParser.FAILOVER_DATA_CONNECTOR_ELEMENT_NAME)) != null && !failoverConnector.isEmpty()) {
            if (failoverConnector.size() > 1) {
                this.log.warn("{} More than one failover data connector specified, taking the first", (Object)this.getLogPrefix());
            }
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

