/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AttributeResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<AttributeResolver>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceStrategy.class);
    private boolean stripNulls;

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    public void setStripNulls(boolean doStripNulls) {
        this.stripNulls = doStripNulls;
    }

    @Override
    @Nullable
    public ServiceableComponent<AttributeResolver> apply(@Nullable ApplicationContext appContext) {
        Collection definitions = appContext.getBeansOfType(AttributeDefinition.class).values();
        Collection connectors = appContext.getBeansOfType(DataConnector.class).values();
        this.log.debug("Creating Attribute Resolver {} with {} Attribute Definition(s) and {} Data Connector(s)", new Object[]{this.getId(), definitions.size(), connectors.size()});
        AttributeResolverImpl resolver = new AttributeResolverImpl();
        resolver.setAttributeDefinitions(definitions);
        resolver.setDataConnectors(connectors);
        resolver.setId(this.getId());
        resolver.setStripNulls(Boolean.valueOf(this.isStripNulls()));
        resolver.setApplicationContext(appContext);
        try {
            resolver.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute resolver for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return resolver;
    }
}

