/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

public class ExternalAuthentication {
    @Nonnull
    @NotEmpty
    public static final String CONVERSATION_KEY = "conversation";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_KEY = "principal";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_NAME_KEY = "principal_name";
    @Nonnull
    @NotEmpty
    public static final String SUBJECT_KEY = "subject";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_INSTANT_KEY = "authnInstant";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_ERROR_KEY = "authnError";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_EXCEPTION_KEY = "authnException";
    @Nonnull
    @NotEmpty
    public static final String DONOTCACHE_KEY = "doNotCache";
    @Nonnull
    @NotEmpty
    public static final String FORCE_AUTHN_PARAM = "forceAuthn";
    @Nonnull
    @NotEmpty
    public static final String PASSIVE_AUTHN_PARAM = "isPassive";
    @Deprecated
    @Nonnull
    @NotEmpty
    public static final String AUTHN_METHOD_PARAM = "authnMethod";
    @Nonnull
    @NotEmpty
    public static final String RELYING_PARTY_PARAM = "relyingParty";

    @Nonnull
    @NotEmpty
    public static String startExternalAuthentication(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        String conv = request.getParameter(CONVERSATION_KEY);
        if (conv == null) {
            throw new ExternalAuthenticationException("No conversation key found in request");
        }
        Object obj = request.getSession().getAttribute(CONVERSATION_KEY + conv);
        if (obj == null || !(obj instanceof ExternalAuthentication)) {
            throw new ExternalAuthenticationException("No conversation state found in session");
        }
        ((ExternalAuthentication)obj).doStart(request);
        return conv;
    }

    public static void finishExternalAuthentication(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalAuthenticationException, IOException {
        Object obj = request.getSession().getAttribute(CONVERSATION_KEY + key);
        if (obj == null || !(obj instanceof ExternalAuthentication)) {
            throw new ExternalAuthenticationException("No conversation state found in session");
        }
        request.getSession().removeAttribute(CONVERSATION_KEY + key);
        ((ExternalAuthentication)obj).doFinish(request, response);
    }

    protected void doStart(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        throw new ExternalAuthenticationException("Not implemented");
    }

    protected void doFinish(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalAuthenticationException, IOException {
        throw new ExternalAuthenticationException("Not implemented");
    }
}

