/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;

public final class AuthenticationContext
extends BaseContext {
    @Positive
    private final long initiationInstant = System.currentTimeMillis();
    private boolean forceAuthn;
    private boolean isPassive;
    private boolean isBrowserProfile;
    @Nullable
    private String hintedName;
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> potentialFlows = new LinkedHashMap<String, AuthenticationFlowDescriptor>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationResult> activeResults = new HashMap<String, AuthenticationResult>();
    @Nonnull
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> intermediateFlows = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nullable
    private AuthenticationFlowDescriptor attemptedFlow;
    @Nullable
    private AuthenticationResult authenticationResult;
    private boolean resultCacheable = true;
    @NonNegative
    private long completionInstant;

    public AuthenticationContext() {
        this.evalRegistry = new PrincipalEvalPredicateFactoryRegistry();
    }

    @Positive
    public long getInitiationInstant() {
        return this.initiationInstant;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AuthenticationResult> getActiveResults() {
        return ImmutableMap.copyOf(this.activeResults);
    }

    @Nonnull
    public AuthenticationContext setActiveResults(@Nonnull @NonnullElements Iterable<AuthenticationResult> results) {
        Constraint.isNotNull(results, (String)"AuthenticationResult collection cannot be null");
        this.activeResults.clear();
        for (AuthenticationResult result : results) {
            this.activeResults.put(result.getAuthenticationFlowId(), result);
        }
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getPotentialFlows() {
        return this.potentialFlows;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getIntermediateFlows() {
        return this.intermediateFlows;
    }

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalEvalPredicateFactoryRegistry() {
        return this.evalRegistry;
    }

    public void setPrincipalEvalPredicateFactoryRegistry(@Nonnull PrincipalEvalPredicateFactoryRegistry registry) {
        this.evalRegistry = (PrincipalEvalPredicateFactoryRegistry)Constraint.isNotNull((Object)registry, (String)"PrincipalEvalPredicateFactoryRegistry cannot be null");
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    @Nonnull
    public AuthenticationContext setIsPassive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public boolean isBrowserProfile() {
        return this.isBrowserProfile;
    }

    @Nonnull
    public AuthenticationContext setBrowserProfile(boolean browser) {
        this.isBrowserProfile = browser;
        return this;
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    @Nonnull
    public AuthenticationContext setForceAuthn(boolean force) {
        this.forceAuthn = force;
        return this;
    }

    @Nullable
    public String getHintedName() {
        return this.hintedName;
    }

    @Nonnull
    public AuthenticationContext setHintedName(@Nullable String hint) {
        this.hintedName = StringSupport.trimOrNull((String)hint);
        return this;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAttemptedFlow() {
        return this.attemptedFlow;
    }

    @Nonnull
    public AuthenticationContext setAttemptedFlow(@Nullable AuthenticationFlowDescriptor flow) {
        this.attemptedFlow = flow;
        return this;
    }

    @Nullable
    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    @Nonnull
    public AuthenticationContext setAuthenticationResult(@Nullable AuthenticationResult result) {
        this.authenticationResult = result;
        return this;
    }

    public boolean isResultCacheable() {
        return this.resultCacheable;
    }

    public void setResultCacheable(boolean flag) {
        this.resultCacheable = flag;
    }

    @NonNegative
    public long getCompletionInstant() {
        return this.completionInstant;
    }

    @Nonnull
    public AuthenticationContext setCompletionInstant() {
        this.completionInstant = System.currentTimeMillis();
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("initiationInstant", (Object)new DateTime(this.initiationInstant)).add("isBrowserProfile", this.isBrowserProfile).add("isPassive", this.isPassive).add("forceAuthn", this.forceAuthn).add("hintedName", (Object)this.hintedName).add("potentialFlows", this.potentialFlows.keySet()).add("activeResults", this.activeResults.keySet()).add("attemptedFlow", (Object)this.attemptedFlow).add("resultCacheable", this.resultCacheable).add("completionInstant", (Object)new DateTime(this.completionInstant)).toString();
    }
}

