/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrincipalEvalPredicateFactoryRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrincipalEvalPredicateFactoryRegistry.class);
    @Nonnull
    @NonnullElements
    private Map<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory> registry;

    public PrincipalEvalPredicateFactoryRegistry() {
        this.registry = new ConcurrentHashMap<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory>();
    }

    public PrincipalEvalPredicateFactoryRegistry(@Nonnull @NonnullElements Map<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory> fromMap) {
        this.registry = new ConcurrentHashMap<Pair<Class<? extends Principal>, String>, PrincipalEvalPredicateFactory>((Map)Constraint.isNotNull(fromMap, (String)"Source map cannot be null"));
    }

    @Nullable
    public PrincipalEvalPredicateFactory lookup(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        Pair key = new Pair(principalType, (Object)trimmed);
        PrincipalEvalPredicateFactory factory = this.registry.get(key);
        if (factory != null) {
            this.log.debug("Registry located predicate factory of type '{}' for principal type '{}' and operator '{}'", new Object[]{factory.getClass().getName(), principalType, trimmed});
            return factory;
        }
        this.log.debug("Registry failed to locate predicate factory for principal type '{}' and operator '{}'", principalType, (Object)trimmed);
        return null;
    }

    public void register(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator, @Nonnull PrincipalEvalPredicateFactory factory) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        Constraint.isNotNull((Object)factory, (String)"PrincipalEvalPredicateFactory cannot be null");
        this.log.debug("Registering predicate factory of type '{}' for principal type '{}' and operator '{}'", new Object[]{factory.getClass().getName(), principalType, operator});
        this.registry.put((Pair<Class<? extends Principal>, String>)new Pair(principalType, (Object)trimmed), factory);
    }

    public void deregister(@Nonnull Class<? extends Principal> principalType, @Nonnull @NotEmpty String operator) {
        Constraint.isNotNull(principalType, (String)"Principal subtype cannot be null");
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operator), (String)"Operator cannot be null or empty");
        this.log.debug("Deregistering predicate factory for principal type '{}' and operator '{}'", principalType, (Object)operator);
        this.registry.remove(new Pair(principalType, (Object)trimmed));
    }
}

