/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Function;
import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultPrincipalDeterminationStrategy<T extends Principal>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnContextLookupStrategy;
    @Nonnull
    private final Class<T> principalType;
    @Nonnull
    private final T defaultPrincipal;

    public DefaultPrincipalDeterminationStrategy(@Nonnull Class<T> type, @Nonnull T principal) {
        this.principalType = (Class)Constraint.isNotNull(type, (String)"Class type cannot be null");
        this.defaultPrincipal = (Principal)Constraint.isNotNull(principal, (String)"Default Principal cannot be null");
        this.authnContextLookupStrategy = new ChildContextLookup(AuthenticationContext.class, false);
    }

    public void setAuthenticationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        this.authnContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        AuthenticationContext ac = (AuthenticationContext)((Object)this.authnContextLookupStrategy.apply((Object)input));
        if (ac == null || ac.getAuthenticationResult() == null) {
            return this.defaultPrincipal;
        }
        Set<T> principals = ac.getAuthenticationResult().getSupportedPrincipals(this.principalType);
        if (principals.isEmpty()) {
            return this.defaultPrincipal;
        }
        return (T)((Principal)principals.iterator().next());
    }
}

