/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;

@ThreadSafe
public class AuthenticationResult
implements PrincipalSupportingComponent {
    @Nonnull
    private final Subject subject;
    @Nonnull
    @NotEmpty
    private final String authenticationFlowId;
    @Positive
    private long authenticationInstant;
    @Positive
    private long lastActivityInstant;

    public AuthenticationResult(@Nonnull @NotEmpty String flowId, @Nonnull Subject newSubject) {
        this.authenticationFlowId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)flowId), (String)"Authentication flow ID cannot be null nor empty");
        this.subject = (Subject)Constraint.isNotNull((Object)newSubject, (String)"Subject list cannot be null or empty");
        this.lastActivityInstant = this.authenticationInstant = System.currentTimeMillis();
    }

    public AuthenticationResult(@Nonnull @NotEmpty String flowId, @Nonnull Principal principal) {
        this(flowId, new Subject(false, (Set<? extends Principal>)ImmutableSet.of((Object)Constraint.isNotNull((Object)principal, (String)"Principal cannot be null")), Collections.EMPTY_SET, Collections.EMPTY_SET));
    }

    @Nonnull
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.subject.getPrincipals(c);
    }

    @Nonnull
    @NotEmpty
    public String getAuthenticationFlowId() {
        return this.authenticationFlowId;
    }

    @Positive
    public long getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(@Positive long instant) {
        this.authenticationInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Authentication instant must be greater than 0");
    }

    @Positive
    public long getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(@Positive long instant) {
        this.lastActivityInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Last activity instant must be greater than 0");
    }

    public void setLastActivityInstantToNow() {
        this.lastActivityInstant = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.authenticationFlowId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthenticationResult) {
            return Objects.equals(this.getAuthenticationFlowId(), ((AuthenticationResult)obj).getAuthenticationFlowId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authenticationFlowId", (Object)this.authenticationFlowId).add("authenticatedPrincipal", (Object)this.getSubjectName()).add("authenticationInstant", (Object)new DateTime(this.authenticationInstant)).add("lastActivityInstant", (Object)new DateTime(this.lastActivityInstant)).toString();
    }

    @Nullable
    private String getSubjectName() {
        Set<UsernamePrincipal> usernames = this.getSubject().getPrincipals(UsernamePrincipal.class);
        if (!usernames.isEmpty()) {
            return usernames.iterator().next().getName();
        }
        Iterator<Principal> i$ = this.getSubject().getPrincipals().iterator();
        if (i$.hasNext()) {
            Principal p = i$.next();
            return p.getName();
        }
        return null;
    }
}

