/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUsernamePasswordValidationAction
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.password";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractUsernamePasswordValidationAction.class);
    private boolean savePasswordToCredentialSet;
    private boolean removeContextAfterValidation = true;
    @Nullable
    private Pattern matchExpression;
    @Nullable
    private AccountLockoutManager lockoutManager;
    @Nullable
    private UsernamePasswordContext upContext;

    public AbstractUsernamePasswordValidationAction() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public boolean savePasswordToCredentialSet() {
        return this.savePasswordToCredentialSet;
    }

    public void setSavePasswordToCredentialSet(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.savePasswordToCredentialSet = flag;
    }

    public boolean removeContextAfterValidation() {
        return this.removeContextAfterValidation;
    }

    public void setRemoveContextAfterValidation(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removeContextAfterValidation = flag;
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression;
    }

    @Nullable
    public AccountLockoutManager getLockoutManager() {
        return this.lockoutManager;
    }

    public void setLockoutManager(@Nullable AccountLockoutManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lockoutManager = manager;
    }

    @Nullable
    public UsernamePasswordContext getUsernamePasswordContext() {
        return this.upContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
        if (this.upContext == null) {
            this.log.info("{} No UsernamePasswordContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            this.recordFailure();
            return false;
        }
        if (this.upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            this.recordFailure();
            return false;
        }
        if (this.upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure();
            return false;
        }
        if (this.matchExpression != null && !this.matchExpression.matcher(this.upContext.getUsername()).matches()) {
            this.log.debug("{} Username '{}' did not match expression", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure();
            return false;
        }
        if (this.lockoutManager != null && this.lockoutManager.check(profileRequestContext)) {
            this.log.info("{} Account for '{}' is locked out, aborting authentication", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
            this.handleError(profileRequestContext, authenticationContext, "AccountLocked", "AccountLocked");
            this.recordFailure();
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add(new UsernamePrincipal(this.upContext.getUsername()));
        if (this.savePasswordToCredentialSet) {
            subject.getPrivateCredentials().add(new PasswordPrincipal(this.upContext.getPassword()));
        }
        if (this.removeContextAfterValidation) {
            this.upContext.getParent().removeSubcontext((BaseContext)this.upContext);
            this.upContext.setPassword(null);
            this.upContext = null;
        }
        return subject;
    }

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        this.recordSuccess();
        if (this.lockoutManager != null) {
            this.lockoutManager.clear(profileRequestContext);
        }
    }

    protected void recordFailure(@Nonnull ProfileRequestContext profileRequestContext, boolean inc) {
        this.recordFailure();
        if (inc && this.lockoutManager != null) {
            this.lockoutManager.increment(profileRequestContext);
        }
    }
}

