/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public class PreferredPrincipalContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private List<Principal> preferredPrincipals = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Principal> getPreferredPrincipals() {
        return this.preferredPrincipals;
    }

    @Nonnull
    public PreferredPrincipalContext setPreferredPrincipals(@Nonnull @NonnullElements List<Principal> principals) {
        Constraint.isNotNull(principals, (String)"Principal list cannot be null");
        this.preferredPrincipals = ImmutableList.copyOf((Collection)Collections2.filter(principals, (Predicate)Predicates.notNull()));
        return this;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        return !Collections.disjoint(this.preferredPrincipals, component.getSupportedPrincipals(Principal.class));
    }

    public boolean isAcceptable(@Nonnull @NonnullElements Collection<Principal> principals) {
        return !Collections.disjoint(this.preferredPrincipals, principals);
    }

    public <T extends Principal> boolean isAcceptable(@Nonnull T principal) {
        return this.preferredPrincipals.contains(principal);
    }
}

