/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Predicates;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCredentialValidator
extends AbstractIdentifiedInitializableComponent
implements CredentialValidator,
PrincipalSupportingComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractCredentialValidator.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @Nullable
    private String logPrefix;
    @Nullable
    private Subject customPrincipals;

    public synchronized void setId(String id) {
        super.setId(id);
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.customPrincipals != null ? this.customPrincipals.getPrincipals(c) : Collections.emptySet();
    }

    public void setSupportedPrincipals(@Nullable @NonnullElements Collection<Principal> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (principals != null) {
            Set<Principal> copy = Set.copyOf(principals);
            if (!copy.isEmpty()) {
                this.customPrincipals = new Subject();
                this.customPrincipals.getPrincipals().addAll(copy);
            } else {
                this.customPrincipals = null;
            }
        } else {
            this.customPrincipals = null;
        }
    }

    @Override
    public Subject validate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!this.activationCondition.test(profileRequestContext)) {
            this.log.debug("{} Activation condition was false, ignoring request", (Object)this.getLogPrefix());
            return null;
        }
        if (!this.isAcceptable((RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class), this.customPrincipals, this.getId())) {
            return null;
        }
        return this.doValidate(profileRequestContext, authenticationContext, warningHandler, errorHandler);
    }

    @Nullable
    protected abstract Subject doValidate(@Nonnull ProfileRequestContext var1, @Nonnull AuthenticationContext var2, @Nullable CredentialValidator.WarningHandler var3, @Nullable CredentialValidator.ErrorHandler var4) throws Exception;

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        if (this.customPrincipals != null) {
            subject.getPrincipals().addAll(this.customPrincipals.getPrincipals());
        }
        return subject;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Credential Validator " + (this.getId() != null ? this.getId() : "(unknown)") + ":";
        }
        return this.logPrefix;
    }

    protected boolean isAcceptable(@Nullable RequestedPrincipalContext requestedPrincipalCtx, final @Nullable Subject subject, @Nonnull @NotEmpty String configName) {
        if (subject != null && requestedPrincipalCtx != null && requestedPrincipalCtx.getOperator() != null) {
            this.log.debug("{} Request contains principal requirements, checking validator '{}' for compatibility", (Object)this.getLogPrefix(), (Object)configName);
            for (Principal p : requestedPrincipalCtx.getRequestedPrincipals()) {
                PrincipalEvalPredicateFactory factory = requestedPrincipalCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), requestedPrincipalCtx.getOperator());
                if (factory != null) {
                    PrincipalSupportingComponent wrapper;
                    PrincipalEvalPredicate predicate = factory.getPredicate(p);
                    if (predicate.test(wrapper = new PrincipalSupportingComponent(){

                        @Override
                        public <T extends Principal> Set<T> getSupportedPrincipals(Class<T> c) {
                            return subject.getPrincipals(c);
                        }
                    })) {
                        this.log.debug("{} Validator '{}' compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), requestedPrincipalCtx.getOperator()});
                        requestedPrincipalCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                        return true;
                    }
                    this.log.debug("{} Validator '{}' not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), requestedPrincipalCtx.getOperator()});
                    continue;
                }
                this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), requestedPrincipalCtx.getOperator()});
            }
            this.log.debug("{} Skipping validator '{}', not compatible with request's principal requirements", (Object)this.getLogPrefix(), (Object)configName);
            return false;
        }
        return true;
    }
}

