/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.net.InetAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public final class UserAgentContext
extends BaseContext {
    @Nullable
    private InetAddress address;
    @Nullable
    private String identifier;
    @Nullable
    private UserAgent userAgent;

    @Nullable
    public InetAddress getAddress() {
        return this.address;
    }

    @Nonnull
    public UserAgentContext setAddress(@Nullable InetAddress userAgentAddress) {
        this.address = userAgentAddress;
        return this;
    }

    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public UserAgentContext setIdentifier(@Nullable String id) {
        this.identifier = id;
        this.userAgent = new UserAgent(id);
        return this;
    }

    @Nullable
    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public boolean isInstance(@Nonnull Browser browser) {
        Constraint.isNotNull((Object)browser, (String)"Browser cannot be null");
        if (this.userAgent == null) {
            return false;
        }
        return this.userAgent.getBrowser().getGroup().equals((Object)browser) || this.userAgent.getBrowser().equals((Object)browser);
    }

    public boolean isInstance(@Nonnull OperatingSystem os) {
        Constraint.isNotNull((Object)os, (String)"OperatingSystem cannot be null");
        if (this.userAgent == null) {
            return false;
        }
        return this.userAgent.getOperatingSystem().getGroup().equals((Object)os) || this.userAgent.getOperatingSystem().equals((Object)os);
    }
}

