/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.SimplePrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SealedPrincipalSerializer<T extends Principal>
extends SimplePrincipalSerializer<T> {
    @Nonnull
    @NotEmpty
    private static final String PASSWORD_FIELD = "PW";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SealedPrincipalSerializer.class);
    @Nullable
    private DataSealer sealer;

    public SealedPrincipalSerializer(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nonnull @ParameterName(name="name") @NotEmpty String name) throws NoSuchMethodException, SecurityException {
        super(claz, name);
    }

    public void setDataSealer(@Nullable DataSealer theSealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sealer = theSealer;
    }

    @Override
    public boolean supports(@Nonnull Principal principal) {
        if (this.sealer == null) {
            this.log.error("No DataSealer was provided, unable to support serialization");
            return false;
        }
        return super.supports(principal);
    }

    @Override
    public boolean supports(@Nonnull @NotEmpty String value) {
        if (this.sealer == null) {
            this.log.error("No DataSealer was provided, unable to support deserialization");
            return false;
        }
        return super.supports(value);
    }

    @Override
    protected String getName(@Nonnull Principal principal) throws IOException {
        try {
            return this.sealer.wrap(super.getName(principal));
        }
        catch (DataSealerException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String getName(@Nullable String serializedName) throws IOException {
        if (!Strings.isNullOrEmpty((String)serializedName)) {
            try {
                return this.sealer.unwrap(serializedName);
            }
            catch (DataSealerException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

