/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SimplePrincipalSerializer<T extends Principal>
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimplePrincipalSerializer.class);
    @Nonnull
    private final Class<T> principalType;
    @Nonnull
    private final Constructor<T> ctor;
    @Nonnull
    @NotEmpty
    private final String fieldName;
    @Nonnull
    private final Pattern jsonPattern;

    public SimplePrincipalSerializer(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nonnull @ParameterName(name="name") @NotEmpty String name) throws NoSuchMethodException, SecurityException {
        this.principalType = (Class)Constraint.isNotNull(claz, (String)"Principal type cannot be null");
        this.ctor = this.principalType.getConstructor(String.class);
        this.fieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Field name cannot be empty or null");
        this.jsonPattern = Pattern.compile("^\\{\"" + this.fieldName + "\":.*\\}$");
    }

    @Override
    public boolean supports(@Nonnull Principal principal) {
        return this.principalType.isInstance(principal);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(this.fieldName, this.getName(principal)).writeEnd();
        }
        return sink.toString();
    }

    @Nonnull
    @NotEmpty
    protected String getName(@Nonnull Principal principal) throws IOException {
        return principal.getName();
    }

    @Override
    public boolean supports(@Nonnull @NotEmpty String value) {
        return this.jsonPattern.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public T deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            String name;
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing " + this.principalType.getSimpleName());
            }
            JsonString str = ((JsonObject)st).getJsonString(this.fieldName);
            if (str != null && !Strings.isNullOrEmpty((String)(name = this.getName(str.getString())))) {
                Principal principal = (Principal)this.ctor.newInstance(name);
                return (T)principal;
            }
            T t = null;
            return t;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing " + this.principalType.getSimpleName(), e);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Unable to reflectively create " + this.principalType.getSimpleName(), e);
        }
    }

    @Nullable
    protected String getName(@Nullable String serializedName) throws IOException {
        return serializedName;
    }
}

