/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public abstract class AbstractUsernamePasswordCredentialValidator
extends AbstractCredentialValidator {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.password";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractUsernamePasswordCredentialValidator.class);
    @Nonnull
    private Function<AuthenticationContext, UsernamePasswordContext> usernamePasswordContextLookupStrategy = new ChildContextLookup(UsernamePasswordContext.class);
    private boolean savePasswordToCredentialSet;
    private boolean removeContextAfterValidation;
    @Nullable
    private Pattern matchExpression;
    @Nonnull
    @NonnullElements
    private List<Pair<Pattern, String>> transforms = Collections.emptyList();
    private boolean uppercase = false;
    private boolean lowercase = false;
    private boolean trim = false;

    public void setUsernamePasswordContextLookupStrategy(@Nonnull Function<AuthenticationContext, UsernamePasswordContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.usernamePasswordContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UsernamePasswordContextLookupStrategy cannot be null");
    }

    public boolean savePasswordToCredentialSet() {
        return this.savePasswordToCredentialSet;
    }

    public void setSavePasswordToCredentialSet(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.savePasswordToCredentialSet = flag;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public boolean removeContextAfterValidation() {
        return this.removeContextAfterValidation;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setRemoveContextAfterValidation(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removeContextAfterValidation = flag;
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    public void setTransforms(@Nullable @NonnullElements Collection<Pair<String, String>> newTransforms) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newTransforms != null) {
            this.transforms = new ArrayList<Pair<Pattern, String>>();
            for (Pair<String, String> p : newTransforms) {
                Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
                this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
            }
        } else {
            this.transforms = Collections.emptyList();
        }
    }

    public void setUppercase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lowercase = flag;
    }

    public void setTrim(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.trim = flag;
    }

    @Override
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        UsernamePasswordContext upContext = this.usernamePasswordContextLookupStrategy.apply(authenticationContext);
        if (upContext == null) {
            this.log.debug("{} No UsernamePasswordContext available", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        if (upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        if (upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            }
            throw new LoginException("InvalidCredentials");
        }
        upContext.setTransformedUsername(this.applyTransforms(upContext.getUsername()));
        if (this.matchExpression != null && !this.matchExpression.matcher(upContext.getTransformedUsername()).matches()) {
            this.log.debug("{} Username '{}' did not match expression", (Object)this.getLogPrefix(), (Object)upContext.getTransformedUsername());
            return null;
        }
        return this.doValidate(profileRequestContext, authenticationContext, upContext, warningHandler, errorHandler);
    }

    @Nullable
    protected abstract Subject doValidate(@Nonnull ProfileRequestContext var1, @Nonnull AuthenticationContext var2, @Nonnull UsernamePasswordContext var3, @Nullable CredentialValidator.WarningHandler var4, @Nullable CredentialValidator.ErrorHandler var5) throws Exception;

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject, @Nonnull UsernamePasswordContext usernamePasswordContext) {
        subject.getPrincipals().add(new UsernamePrincipal(usernamePasswordContext.getTransformedUsername()));
        if (this.savePasswordToCredentialSet) {
            subject.getPrivateCredentials().add(new PasswordPrincipal(usernamePasswordContext.getPassword()));
        }
        if (this.removeContextAfterValidation) {
            usernamePasswordContext.getParent().removeSubcontext((BaseContext)usernamePasswordContext);
            usernamePasswordContext.setPassword(null);
        }
        return super.populateSubject(subject);
    }

    @Nonnull
    @NotEmpty
    protected String applyTransforms(@Nonnull @NotEmpty String input) {
        String s = input;
        if (this.trim) {
            this.log.trace("{} Trimming whitespace of input string '{}'", (Object)this.getLogPrefix(), (Object)s);
            s = s.trim();
        }
        if (this.lowercase) {
            this.log.trace("{} Converting input string '{}' to lowercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.trace("{} Converting input string '{}' to uppercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toUpperCase();
        }
        if (this.transforms.isEmpty()) {
            return s;
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Matcher m = ((Pattern)p.getFirst()).matcher(s);
            this.log.trace("{} Applying replacement expression '{}' against input '{}'", new Object[]{this.getLogPrefix(), ((Pattern)p.getFirst()).pattern(), s});
            s = m.replaceAll((String)p.getSecond());
            this.log.trace("{} Result of replacement is '{}'", (Object)this.getLogPrefix(), (Object)s);
        }
        return s;
    }
}

