/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import java.security.Principal;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationResult
implements PrincipalSupportingComponent,
Predicate<ProfileRequestContext> {
    @Nonnull
    private final Subject subject;
    @Nonnull
    @NotEmpty
    private final String authenticationFlowId;
    @Nonnull
    private Instant authenticationInstant;
    @Nonnull
    private Instant lastActivityInstant;
    private boolean previousResult;
    @Nonnull
    @NonnullElements
    private final Map<String, String> additionalData;
    @Nonnull
    private Predicate<ProfileRequestContext> reuseCondition;
    @Nonnull
    private BiPredicate<ProfileRequestContext, AuthenticationResult> revocationCondition;

    public AuthenticationResult(@Nonnull @NotEmpty String flowId, @Nonnull Subject newSubject) {
        this.authenticationFlowId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)flowId), (String)"Authentication flow ID cannot be null nor empty");
        this.subject = (Subject)Constraint.isNotNull((Object)newSubject, (String)"Subject list cannot be null or empty");
        this.lastActivityInstant = this.authenticationInstant = Instant.now();
        this.additionalData = new HashMap<String, String>();
        this.reuseCondition = new DescriptorReusePredicate();
        this.revocationCondition = new DescriptorRevocationPredicate();
    }

    public AuthenticationResult(@Nonnull @NotEmpty String flowId, @Nonnull Principal principal) {
        this(flowId, new Subject(false, Collections.singleton((Principal)Constraint.isNotNull((Object)principal, (String)"Principal cannot be null")), Collections.emptySet(), Collections.emptySet()));
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getReuseCondition() {
        return this.reuseCondition;
    }

    public void setReuseCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.reuseCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    public void setRevocationCondition(@Nullable BiPredicate<ProfileRequestContext, AuthenticationResult> condition) {
        this.revocationCondition = condition;
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        if (this.reuseCondition.test(input)) {
            return this.revocationCondition != null ? !this.revocationCondition.test(input, this) : true;
        }
        return false;
    }

    @Nonnull
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.subject.getPrincipals(c);
    }

    @Nonnull
    @NotEmpty
    public String getAuthenticationFlowId() {
        return this.authenticationFlowId;
    }

    @Nonnull
    public Instant getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(@Nonnull Instant instant) {
        this.authenticationInstant = (Instant)Constraint.isNotNull((Object)instant, (String)"Authentication instant cannot be null");
    }

    @Nonnull
    public Instant getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(@Nonnull Instant instant) {
        this.lastActivityInstant = (Instant)Constraint.isNotNull((Object)instant, (String)"Last activity instant cannot be null");
    }

    public void setLastActivityInstantToNow() {
        this.lastActivityInstant = Instant.now();
    }

    public boolean isPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(boolean flag) {
        this.previousResult = flag;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public int hashCode() {
        return this.authenticationFlowId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthenticationResult) {
            return Objects.equals(this.getAuthenticationFlowId(), ((AuthenticationResult)obj).getAuthenticationFlowId()) && this.getAuthenticationInstant().equals(((AuthenticationResult)obj).getAuthenticationInstant());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authenticationFlowId", (Object)this.authenticationFlowId).add("authenticatedPrincipal", (Object)this.getSubjectName()).add("authenticationInstant", (Object)this.authenticationInstant).add("lastActivityInstant", (Object)this.lastActivityInstant).add("previousResult", this.previousResult).toString();
    }

    @Nullable
    private String getSubjectName() {
        Set<UsernamePrincipal> usernames = this.getSubject().getPrincipals(UsernamePrincipal.class);
        if (!usernames.isEmpty()) {
            return usernames.iterator().next().getName();
        }
        Set<Principal> principals = this.getSubject().getPrincipals();
        if (!principals.isEmpty()) {
            return principals.iterator().next().getName();
        }
        return null;
    }

    class DescriptorRevocationPredicate
    implements BiPredicate<ProfileRequestContext, AuthenticationResult> {
        DescriptorRevocationPredicate() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext prc, @Nullable AuthenticationResult result) {
            AuthenticationFlowDescriptor flow;
            AuthenticationContext ac;
            if (prc != null && (ac = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)) != null && (flow = ac.getAvailableFlows().get(AuthenticationResult.this.authenticationFlowId)) != null) {
                if (flow.getRevocationCondition() != null) {
                    return flow.getRevocationCondition().test(prc, result);
                }
                return false;
            }
            return true;
        }
    }

    class DescriptorReusePredicate
    extends ProxyRestrictionReusePredicate {
        DescriptorReusePredicate() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            AuthenticationFlowDescriptor flow;
            AuthenticationContext ac;
            if (input != null && (ac = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && (flow = ac.getAvailableFlows().get(AuthenticationResult.this.authenticationFlowId)) != null && flow.getReuseCondition().test(input) && flow.isProxyRestrictionsEnforced()) {
                return super.test(input);
            }
            return false;
        }
    }

    class ProxyRestrictionReusePredicate
    implements Predicate<ProfileRequestContext> {
        ProxyRestrictionReusePredicate() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            Set<ProxyAuthenticationPrincipal> proxieds = AuthenticationResult.this.subject.getPrincipals(ProxyAuthenticationPrincipal.class);
            if (proxieds == null || proxieds.isEmpty()) {
                return true;
            }
            for (ProxyAuthenticationPrincipal proxied : proxieds) {
                if (proxied.test(input)) continue;
                return false;
            }
            return true;
        }
    }
}

