/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.executor.FlowExecutorImpl;

public abstract class ExternalAuthentication {
    @Nonnull
    @NotEmpty
    public static final String SWF_KEY = "net.shibboleth.idp.flowExecutor";
    @Nonnull
    @NotEmpty
    public static final String CONVERSATION_KEY = "conversation";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_KEY = "principal";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_NAME_KEY = "principal_name";
    @Nonnull
    @NotEmpty
    public static final String SUBJECT_KEY = "subject";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_INSTANT_KEY = "authnInstant";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATING_AUTHORITIES_KEY = "authnAuthorities";
    @Nonnull
    @NotEmpty
    public static final String ATTRIBUTES_KEY = "attributes";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_ERROR_KEY = "authnError";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_EXCEPTION_KEY = "authnException";
    @Nonnull
    @NotEmpty
    public static final String DONOTCACHE_KEY = "doNotCache";
    @Nonnull
    @NotEmpty
    public static final String REVOKECONSENT_KEY = "revokeConsent";
    @Nonnull
    @NotEmpty
    public static final String PREVIOUSRESULT_KEY = "previousResult";
    @Nonnull
    @NotEmpty
    public static final String FORCE_AUTHN_PARAM = "forceAuthn";
    @Nonnull
    @NotEmpty
    public static final String PASSIVE_AUTHN_PARAM = "isPassive";
    @Nonnull
    @NotEmpty
    public static final String RELYING_PARTY_PARAM = "relyingParty";
    @Nonnull
    @NotEmpty
    public static final String EXTENDED_FLOW_PARAM = "extended";

    @Nonnull
    @NotEmpty
    public static String getExternalRedirect(@Nonnull @NotEmpty String baseLocation, @Nonnull @NotEmpty String conversationValue) {
        Constraint.isNotEmpty((String)baseLocation, (String)"Base location cannot be null or empty");
        StringBuilder url = new StringBuilder(baseLocation);
        url.append(baseLocation.indexOf(63) == -1 ? (char)'?' : '&');
        url.append(CONVERSATION_KEY).append('=').append(UrlEscapers.urlFormParameterEscaper().escape(conversationValue));
        return url.toString();
    }

    @Nonnull
    @NotEmpty
    public static String startExternalAuthentication(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        String key = request.getParameter(CONVERSATION_KEY);
        if (Strings.isNullOrEmpty((String)key)) {
            throw new ExternalAuthenticationException("No conversation key found in request");
        }
        ProfileRequestContext profileRequestContext = ExternalAuthentication.getProfileRequestContext(key, request);
        ExternalAuthenticationContext extContext = ExternalAuthentication.getExternalAuthenticationContext(profileRequestContext);
        extContext.getExternalAuthentication().doStart(request, profileRequestContext, extContext);
        return key;
    }

    public static void finishExternalAuthentication(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalAuthenticationException, IOException {
        ProfileRequestContext profileRequestContext = ExternalAuthentication.getProfileRequestContext(key, request);
        ExternalAuthenticationContext extContext = ExternalAuthentication.getExternalAuthenticationContext(profileRequestContext);
        extContext.getExternalAuthentication().doFinish(request, response, profileRequestContext, extContext);
    }

    @Nonnull
    public static ProfileRequestContext getProfileRequestContext(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        Object obj = request.getServletContext().getAttribute(SWF_KEY);
        if (!(obj instanceof FlowExecutorImpl)) {
            if (obj instanceof ProfileRequestContext) {
                return (ProfileRequestContext)obj;
            }
            throw new ExternalAuthenticationException("No FlowExecutor available in servlet context");
        }
        try {
            FlowExecutionRepository repo = ((FlowExecutorImpl)obj).getExecutionRepository();
            ExternalContextHolder.setExternalContext((ExternalContext)new ServletExternalContext(request.getServletContext(), request, null));
            FlowExecution execution = repo.getFlowExecution(repo.parseFlowExecutionKey(key));
            Object prc = execution.getConversationScope().get("opensamlProfileRequestContext");
            if (!(prc instanceof ProfileRequestContext)) {
                throw new ExternalAuthenticationException("ProfileRequestContext not available in webflow conversation scope");
            }
            ProfileRequestContext profileRequestContext = (ProfileRequestContext)prc;
            return profileRequestContext;
        }
        catch (FlowExecutionRepositoryException e) {
            throw new ExternalAuthenticationException("Error retrieving flow conversation", (Exception)((Object)e));
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    @Nonnull
    private static ExternalAuthenticationContext getExternalAuthenticationContext(@Nonnull ProfileRequestContext profileRequestContext) throws ExternalAuthenticationException {
        AuthenticationContext authContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authContext == null) {
            throw new ExternalAuthenticationException("No AuthenticationContext found");
        }
        ExternalAuthenticationContext extContext = (ExternalAuthenticationContext)authContext.getSubcontext(ExternalAuthenticationContext.class);
        if (extContext == null) {
            throw new ExternalAuthenticationException("No ExternalInterceptorContext found");
        }
        return extContext;
    }

    protected void doStart(@Nonnull HttpServletRequest request, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalAuthenticationContext externalAuthenticationContext) throws ExternalAuthenticationException {
        request.setAttribute("opensamlProfileRequestContext", (Object)profileRequestContext);
    }

    protected abstract void doFinish(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull ProfileRequestContext var3, @Nonnull ExternalAuthenticationContext var4) throws ExternalAuthenticationException, IOException;
}

