/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;

public final class AuthenticationContext
extends BaseContext {
    @Nonnull
    private final Instant initiationInstant = Instant.now();
    private boolean forceAuthn;
    private boolean isPassive;
    @Nullable
    private String requiredName;
    @Nullable
    private String hintedName;
    @Nullable
    private Duration maxAge;
    @Nullable
    private String authenticatingAuthority;
    @Nullable
    @NonNegative
    private Integer proxyCount;
    @Nullable
    @NonnullElements
    private Set<String> proxiableAuthorities;
    @Nullable
    private Function<ProfileRequestContext, String> fixedEventLookupStrategy;
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> availableFlows = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> potentialFlows = new LinkedHashMap<String, AuthenticationFlowDescriptor>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationResult> activeResults = new HashMap<String, AuthenticationResult>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> intermediateFlows = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nullable
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;
    @Nullable
    private AuthenticationFlowDescriptor attemptedFlow;
    @Nullable
    private String signaledFlowId;
    @Nonnull
    private final Map<String, Object> stateMap = new HashMap<String, Object>();
    @Nullable
    private AuthenticationResult authenticationResult;
    private boolean resultCacheable = true;
    @Nullable
    private Instant completionInstant;

    public AuthenticationContext() {
        this.proxiableAuthorities = new HashSet<String>();
    }

    @Nonnull
    public Instant getInitiationInstant() {
        return this.initiationInstant;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationResult> getActiveResults() {
        return this.activeResults;
    }

    @Nonnull
    public AuthenticationContext setActiveResults(@Nonnull @NonnullElements Iterable<AuthenticationResult> results) {
        Constraint.isNotNull(results, (String)"AuthenticationResult collection cannot be null");
        this.activeResults.clear();
        for (AuthenticationResult result : results) {
            this.activeResults.put(result.getAuthenticationFlowId(), result);
        }
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getAvailableFlows() {
        return this.availableFlows;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getPotentialFlows() {
        return this.potentialFlows;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getIntermediateFlows() {
        return this.intermediateFlows;
    }

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalEvalPredicateFactoryRegistry() {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.getPrincipalEvalPredicateFactoryRegistry();
        }
        if (this.evalRegistry != null) {
            return this.evalRegistry;
        }
        return new PrincipalEvalPredicateFactoryRegistry();
    }

    @Nonnull
    public AuthenticationContext setPrincipalEvalPredicateFactoryRegistry(@Nullable PrincipalEvalPredicateFactoryRegistry registry) {
        this.evalRegistry = registry;
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            rpCtx.setPrincipalEvalPredicateFactoryRegistry(registry);
        }
        return this;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    @Nonnull
    public AuthenticationContext setIsPassive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    @Nonnull
    public AuthenticationContext setForceAuthn(boolean force) {
        this.forceAuthn = force;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getRequiredName() {
        return this.requiredName;
    }

    @Nonnull
    public AuthenticationContext setRequiredName(@Nullable String name) {
        this.requiredName = name;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getHintedName() {
        return this.hintedName;
    }

    @Nonnull
    public AuthenticationContext setHintedName(@Nullable String hint) {
        this.hintedName = StringSupport.trimOrNull((String)hint);
        return this;
    }

    @Nullable
    public Duration getMaxAge() {
        return this.maxAge;
    }

    @Nonnull
    public AuthenticationContext setMaxAge(@Nullable Duration age) {
        Constraint.isFalse((age != null && (age.isNegative() || age.isZero()) ? 1 : 0) != 0, (String)"MaxAge must be null or greater than 0");
        this.maxAge = age;
        return this;
    }

    @Nullable
    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    @Nonnull
    public AuthenticationContext setAuthenticatingAuthority(@Nullable String authority) {
        this.authenticatingAuthority = StringSupport.trimOrNull((String)authority);
        return this;
    }

    @Nullable
    @NonNegative
    public Integer getProxyCount() {
        return this.proxyCount;
    }

    @Nonnull
    public AuthenticationContext setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count cannot be negative");
        }
        this.proxyCount = count;
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Set<String> getProxiableAuthorities() {
        return this.proxiableAuthorities;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getFixedEventLookupStrategy() {
        return this.fixedEventLookupStrategy;
    }

    @Nonnull
    public AuthenticationContext setFixedEventLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.fixedEventLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAttemptedFlow() {
        return this.attemptedFlow;
    }

    @Nonnull
    public AuthenticationContext setAttemptedFlow(@Nullable AuthenticationFlowDescriptor flow) {
        this.attemptedFlow = flow;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getSignaledFlowId() {
        return this.signaledFlowId;
    }

    @Nonnull
    public AuthenticationContext setSignaledFlowId(@Nullable String id) {
        this.signaledFlowId = StringSupport.trimOrNull((String)id);
        return this;
    }

    @Nonnull
    @Live
    public Map<String, Object> getAuthenticationStateMap() {
        return this.stateMap;
    }

    @Nullable
    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    @Nonnull
    public AuthenticationContext setAuthenticationResult(@Nullable AuthenticationResult result) {
        this.authenticationResult = result;
        return this;
    }

    public boolean isResultCacheable() {
        return this.resultCacheable;
    }

    public void setResultCacheable(boolean flag) {
        this.resultCacheable = flag;
    }

    @Nullable
    public Instant getCompletionInstant() {
        return this.completionInstant;
    }

    @Nonnull
    public AuthenticationContext setCompletionInstant() {
        this.completionInstant = Instant.now();
        return this;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(component);
        }
        return this.checkProxyRestrictions(component.getSupportedPrincipals(ProxyAuthenticationPrincipal.class));
    }

    public boolean isAcceptable(@Nonnull @NonnullElements Collection<Principal> principals) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(principals);
        }
        return this.checkProxyRestrictions(principals.stream().filter(ProxyAuthenticationPrincipal.class::isInstance).map(ProxyAuthenticationPrincipal.class::cast).collect(Collectors.toUnmodifiableList()));
    }

    public <T extends Principal> boolean isAcceptable(@Nonnull T principal) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(principal);
        }
        if (principal instanceof ProxyAuthenticationPrincipal) {
            return this.checkProxyRestrictions(Collections.singletonList((ProxyAuthenticationPrincipal)principal));
        }
        return true;
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NotEmpty String className, @Nonnull @NotEmpty String principal, boolean replace) throws Exception {
        return this.addRequestedPrincipalContext(operator, className, Collections.singletonList(principal), replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NotEmpty String className, @Nonnull Collection<String> principals, boolean replace) throws Exception {
        Class<Principal> claz = Class.forName(className).asSubclass(Principal.class);
        Constructor<Principal> ctor = claz.getConstructor(String.class);
        ArrayList<Principal> prins = new ArrayList<Principal>(principals.size());
        for (String prin : principals) {
            prins.add(ctor.newInstance(prin));
        }
        return this.addRequestedPrincipalContext(operator, prins, replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull Principal principal, boolean replace) {
        return this.addRequestedPrincipalContext(operator, Collections.singletonList(principal), replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NonnullElements List<Principal> principals, boolean replace) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null && !replace) {
            return false;
        }
        rpCtx = new RequestedPrincipalContext();
        rpCtx.setOperator(operator).setPrincipalEvalPredicateFactoryRegistry(this.evalRegistry).setRequestedPrincipals(principals);
        this.addSubcontext(rpCtx, true);
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("initiationInstant", (Object)this.initiationInstant).add("isPassive", this.isPassive).add("forceAuthn", this.forceAuthn).add("requiredName", (Object)this.requiredName).add("hintedName", (Object)this.hintedName).add("maxAge", (Object)this.maxAge).add("potentialFlows", this.potentialFlows.keySet()).add("activeResults", this.activeResults.keySet()).add("attemptedFlow", (Object)this.attemptedFlow).add("signaledFlowId", (Object)this.signaledFlowId).add("authenticationStateMap", this.stateMap).add("resultCacheable", this.resultCacheable).add("authenticationResult", (Object)this.authenticationResult).add("completionInstant", (Object)this.completionInstant).toString();
    }

    private boolean checkProxyRestrictions(@Nullable @NonnullElements Collection<ProxyAuthenticationPrincipal> principals) {
        if (principals == null || principals.isEmpty()) {
            return true;
        }
        BaseContext prc = this.getParent();
        if (!(prc instanceof ProfileRequestContext)) {
            return true;
        }
        for (ProxyAuthenticationPrincipal proxied : principals) {
            if (proxied.test((ProfileRequestContext)prc)) continue;
            return false;
        }
        return true;
    }
}

