/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public final class PreferredPrincipalContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private List<Principal> preferredPrincipals = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Principal> getPreferredPrincipals() {
        return this.preferredPrincipals;
    }

    @Nonnull
    public PreferredPrincipalContext setPreferredPrincipals(@Nonnull @NonnullElements List<Principal> principals) {
        this.preferredPrincipals = List.copyOf((Collection)Constraint.isNotNull(principals, (String)"Principal list cannot be null"));
        return this;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        return !Collections.disjoint(this.preferredPrincipals, component.getSupportedPrincipals(Principal.class));
    }

    public boolean isAcceptable(@Nonnull @NonnullElements Collection<Principal> principals) {
        return !Collections.disjoint(this.preferredPrincipals, principals);
    }

    public <T extends Principal> boolean isAcceptable(@Nonnull T principal) {
        return this.preferredPrincipals.contains(principal);
    }
}

