/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import java.security.Principal;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

@Deprecated(since="4.3.0", forRemoval=true)
public class DefaultPrincipalDeterminationStrategy<T extends Principal>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Class<T> principalType;
    @Nonnull
    private final T defaultPrincipal;
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnContextLookupStrategy;

    public DefaultPrincipalDeterminationStrategy(@Nonnull @ParameterName(name="type") Class<T> type, @Nonnull @ParameterName(name="principal") T principal) {
        this.principalType = (Class)Constraint.isNotNull(type, (String)"Class type cannot be null");
        this.defaultPrincipal = (Principal)Constraint.isNotNull(principal, (String)"Default Principal cannot be null");
        this.authnContextLookupStrategy = new ChildContextLookup(AuthenticationContext.class, false);
    }

    public void setAuthenticationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        this.authnContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        AuthenticationContext ac = this.authnContextLookupStrategy.apply(input);
        if (ac == null || ac.getAuthenticationResult() == null) {
            return this.defaultPrincipal;
        }
        AuthenticationFlowDescriptor descriptor = ac.getAvailableFlows().get(ac.getAuthenticationResult().getAuthenticationFlowId());
        if (descriptor == null) {
            return this.defaultPrincipal;
        }
        Set<T> principals = ac.getAuthenticationResult().getSupportedPrincipals(this.principalType);
        if (principals.isEmpty()) {
            return this.defaultPrincipal;
        }
        return descriptor.getHighestWeighted(principals);
    }
}

