/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalService;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrincipalServiceManager {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrincipalServiceManager.class);
    @Nonnull
    @NonnullElements
    private final Map<Class<?>, PrincipalService<?>> classIndexedMap;
    @Nonnull
    @NonnullElements
    private final Map<String, PrincipalService<?>> idIndexedMap;

    @Autowired
    public PrincipalServiceManager(@Nullable @ParameterName(name="services") @NonnullElements Collection<PrincipalService<?>> services) {
        if (services != null) {
            this.classIndexedMap = new HashMap(services.size());
            this.idIndexedMap = new HashMap(services.size());
            services.forEach(ps -> {
                this.classIndexedMap.put(ps.getType(), (PrincipalService<?>)ps);
                this.idIndexedMap.put(ps.getId(), (PrincipalService<?>)ps);
            });
        } else {
            this.classIndexedMap = Collections.emptyMap();
            this.idIndexedMap = Collections.emptyMap();
        }
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<PrincipalService<?>> all() {
        return List.copyOf(this.classIndexedMap.values());
    }

    @Nullable
    public <T extends Principal> PrincipalService<T> byClass(@Nonnull Class<T> claz) {
        PrincipalService<?> service = this.classIndexedMap.get(claz);
        if (service != null) {
            return service.getType().isAssignableFrom(claz) ? service : null;
        }
        this.log.debug("No service found for Principal type '{}'", (Object)claz.getName());
        return null;
    }

    @Nullable
    public Principal principalFromString(@Nonnull @NotEmpty String s) {
        int index = s.indexOf(47);
        if (index > 1 && index < s.length() - 1) {
            PrincipalService<?> psvc = this.idIndexedMap.get(s.substring(0, index));
            if (psvc != null) {
                try {
                    return (Principal)psvc.getType().getConstructor(String.class).newInstance(s.substring(index + 1));
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                    this.log.error("No suitable constructor available to create instance of '{}'", (Object)psvc.getType().getName(), (Object)e);
                }
            } else {
                this.log.error("No PrincipalService registered under ID '{}'", (Object)s.substring(0, index));
            }
        } else {
            this.log.error("Principal string was not in the expected format");
        }
        return null;
    }
}

