/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractProtocolConfiguration
extends AbstractConditionalProfileConfiguration
implements InitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "https://www.apereo.org/cas/protocol";
    @Nonnull
    public static final Duration DEFAULT_TICKET_VALIDITY_PERIOD = Duration.ofSeconds(15L);
    @Nonnull
    private Function<ProfileRequestContext, Duration> ticketValidityPeriodLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = Predicates.alwaysTrue();
    @Nonnull
    private final SecurityConfiguration defaultSecurityConfiguration;

    public AbstractProtocolConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.ticketValidityPeriodLookupStrategy = FunctionSupport.constant((Object)DEFAULT_TICKET_VALIDITY_PERIOD);
        this.defaultSecurityConfiguration = new SecurityConfiguration(Duration.ofMinutes(5L), (IdentifierGenerationStrategy)new TicketIdentifierGenerationStrategy(this.getDefaultTicketPrefix(), this.getDefaultTicketLength()));
    }

    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        SecurityConfiguration sc = super.getSecurityConfiguration(profileRequestContext);
        return sc != null ? sc : this.defaultSecurityConfiguration;
    }

    @Nonnull
    public Duration getTicketValidityPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration ticketTTL = this.ticketValidityPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)ticketTTL, (String)"Ticket lifetime cannot be null");
        Constraint.isFalse((ticketTTL.isNegative() || ticketTTL.isZero() ? 1 : 0) != 0, (String)"Ticket lifetime must be greater than 0");
        return ticketTTL;
    }

    public void setTicketValidityPeriod(@Nonnull Duration ticketTTL) {
        Constraint.isNotNull((Object)ticketTTL, (String)"Ticket lifetime cannot be null");
        Constraint.isFalse((ticketTTL.isNegative() || ticketTTL.isZero() ? 1 : 0) != 0, (String)"Ticket lifetime must be greater than 0");
        this.ticketValidityPeriodLookupStrategy = FunctionSupport.constant((Object)ticketTTL);
    }

    public void setTicketValidityPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ticketValidityPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @NotEmpty
    protected abstract String getDefaultTicketPrefix();

    protected abstract int getDefaultTicketLength();
}

