/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import com.google.common.base.Predicates;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.cas.config.AbstractProtocolConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class LoginConfiguration
extends AbstractProtocolConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/login";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TICKET_PREFIX = "ST";
    public static final int DEFAULT_TICKET_LENGTH = 25;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> defaultAuthenticationContextsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy = FunctionSupport.constant(null);

    public LoginConfiguration() {
        super(PROFILE_ID);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<AuthnContextClassRefPrincipal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthnContextClassRefPrincipal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant(List.copyOf(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return Set.copyOf(flows);
        }
        return Collections.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    protected int getDefaultTicketLength() {
        return 25;
    }
}

