/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class TicketValidationResponse
extends AbstractProtocolResponse {
    @Nullable
    private String userName;
    @Nonnull
    @NonnullElements
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    @Nullable
    private String pgtIou;
    @Nonnull
    @NonnullElements
    private final List<String> proxies = new ArrayList<String>();

    @Nullable
    @NotEmpty
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(@Nonnull @NotEmpty String user) {
        this.userName = (String)Constraint.isNotNull((Object)user, (String)"Username cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void addAttribute(@Nonnull Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Nullable
    public String getPgtIou() {
        return this.pgtIou;
    }

    public void setPgtIou(@Nullable String iou) {
        this.pgtIou = StringSupport.trimOrNull((String)iou);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getProxies() {
        return Collections.unmodifiableList(this.proxies);
    }

    public void addProxy(@Nonnull String proxy) {
        this.proxies.add(proxy);
    }
}

