/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceDefinition;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternServiceRegistry
extends AbstractServiceableComponent<ServiceRegistry>
implements ServiceRegistry {
    private final Logger log = LoggerFactory.getLogger(PatternServiceRegistry.class);
    @Nonnull
    @NonnullElements
    private Map<ServiceDefinition, Pattern> definitions = Collections.emptyMap();

    public void setDefinitions(@Nonnull @NonnullElements List<ServiceDefinition> serviceDefinitions) {
        Constraint.noNullItems(serviceDefinitions, (String)"Definitions cannot be null or contain null items");
        this.definitions = new LinkedHashMap<ServiceDefinition, Pattern>(serviceDefinitions.size());
        for (ServiceDefinition definition : serviceDefinitions) {
            this.definitions.put(definition, Pattern.compile(definition.getId()));
        }
    }

    @Nonnull
    public ServiceRegistry getComponent() {
        return this;
    }

    @Override
    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        Constraint.isNotNull((Object)serviceURL, (String)"Service URL cannot be null");
        for (ServiceDefinition def : this.definitions.keySet()) {
            this.log.debug("Evaluating whether {} matches {}", (Object)serviceURL, (Object)def);
            if (!this.definitions.get(def).matcher(serviceURL).matches()) continue;
            this.log.debug("Found match");
            return new Service(serviceURL, def.getGroup(), def.isAuthorizedToProxy(), def.isSingleLogoutParticipant());
        }
        return null;
    }
}

