/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class ProxyGrantingTicket
extends Ticket {
    @Nullable
    private String parentPgTicketId;

    public ProxyGrantingTicket(@Nonnull String id, @Nonnull String service, @Nonnull Instant expiration, @Nullable String parentId) {
        super(id, service, expiration);
        this.parentPgTicketId = StringSupport.trimOrNull((String)parentId);
    }

    @Nullable
    public String getParentId() {
        return this.parentPgTicketId;
    }

    public boolean isRoot() {
        return this.getParentId() == null;
    }

    @Override
    protected Ticket newInstance(String newId) {
        return new ProxyGrantingTicket(newId, this.getService(), this.getExpirationInstant(), this.parentPgTicketId);
    }
}

