/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class Ticket {
    @Nonnull
    private final String ticketId;
    @Nonnull
    private final String ticketService;
    @Nonnull
    private final Instant expirationInstant;
    @Nullable
    private TicketState ticketState;

    public Ticket(@Nonnull String id, @Nonnull String service, @Nonnull Instant expiration) {
        this.ticketId = (String)Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        this.ticketService = (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
        this.expirationInstant = (Instant)Constraint.isNotNull((Object)expiration, (String)"Expiration cannot be null");
    }

    @Nonnull
    public String getId() {
        return this.ticketId;
    }

    @Nullable
    public String getSessionId() {
        if (this.ticketState != null) {
            return this.ticketState.getSessionId();
        }
        return null;
    }

    @Nonnull
    public String getService() {
        return this.ticketService;
    }

    @Nonnull
    public Instant getExpirationInstant() {
        return this.expirationInstant;
    }

    @Nullable
    public TicketState getTicketState() {
        return this.ticketState;
    }

    public void setTicketState(@Nullable TicketState state) {
        this.ticketState = state;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Ticket other = (Ticket)o;
        return other.ticketId.equals(this.ticketId);
    }

    public int hashCode() {
        return 23 + 31 * this.ticketId.hashCode();
    }

    public String toString() {
        return this.ticketId;
    }

    public Ticket clone(@Nonnull String newId) {
        Ticket clone = this.newInstance(newId);
        clone.setTicketState(this.ticketState);
        return clone;
    }

    protected Ticket newInstance(@Nonnull String newId) {
        return new Ticket(newId, this.ticketService, this.expirationInstant);
    }
}

