/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.profile.config.AbstractInterceptorAwareProfileConfiguration;
import net.shibboleth.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.BasicSecurityConfiguration;
import org.opensaml.security.config.SecurityConfiguration;

public abstract class AbstractProtocolConfiguration
extends AbstractInterceptorAwareProfileConfiguration
implements AttributeResolvingProfileConfiguration,
InitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "https://www.apereo.org/cas/protocol";
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_COUNTER = "net.shibboleth.idp.profiles.cas";
    @Nonnull
    public static final Duration DEFAULT_TICKET_VALIDITY_PERIOD = Duration.ofSeconds(15L);
    @Nonnull
    private Function<ProfileRequestContext, Duration> ticketValidityPeriodLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private final SecurityConfiguration defaultSecurityConfiguration;

    public AbstractProtocolConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.ticketValidityPeriodLookupStrategy = FunctionSupport.constant((Object)DEFAULT_TICKET_VALIDITY_PERIOD);
        Duration fiveMins = Duration.ofMinutes(5L);
        assert (fiveMins != null);
        this.defaultSecurityConfiguration = new BasicSecurityConfiguration(fiveMins, (IdentifierGenerationStrategy)new TicketIdentifierGenerationStrategy(this.getDefaultTicketPrefix(), this.getDefaultTicketLength()));
    }

    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        SecurityConfiguration sc = super.getSecurityConfiguration(profileRequestContext);
        return sc != null ? sc : this.defaultSecurityConfiguration;
    }

    @ConfigurationSetting(name="ticketValidityPeriod")
    @Nonnull
    public Duration getTicketValidityPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration ticketTTL = this.ticketValidityPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)ticketTTL, (String)"Ticket lifetime cannot be null");
        Constraint.isFalse((ticketTTL.isNegative() || ticketTTL.isZero() ? 1 : 0) != 0, (String)"Ticket lifetime must be greater than 0");
        return ticketTTL;
    }

    public void setTicketValidityPeriod(@Nonnull Duration ticketTTL) {
        Constraint.isNotNull((Object)ticketTTL, (String)"Ticket lifetime cannot be null");
        Constraint.isFalse((ticketTTL.isNegative() || ticketTTL.isZero() ? 1 : 0) != 0, (String)"Ticket lifetime must be greater than 0");
        this.ticketValidityPeriodLookupStrategy = FunctionSupport.constant((Object)ticketTTL);
    }

    public void setTicketValidityPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ticketValidityPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @NotEmpty
    protected abstract String getDefaultTicketPrefix();

    protected abstract int getDefaultTicketLength();
}

